/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.openshift.api.model.ImageStreamStatus;
import io.fabric8.openshift.api.model.ImageStreamStatusFluent;
import io.fabric8.openshift.api.model.NamedTagEventList;
import io.fabric8.openshift.api.model.NamedTagEventListBuilder;
import io.fabric8.openshift.api.model.NamedTagEventListFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ImageStreamStatusFluentImpl<A extends ImageStreamStatusFluent<A>>
extends BaseFluent<A>
implements ImageStreamStatusFluent<A> {
    private String dockerImageRepository;
    private String publicDockerImageRepository;
    private List<NamedTagEventListBuilder> tags = new ArrayList<NamedTagEventListBuilder>();

    public ImageStreamStatusFluentImpl() {
    }

    public ImageStreamStatusFluentImpl(ImageStreamStatus instance) {
        this.withDockerImageRepository(instance.getDockerImageRepository());
        this.withPublicDockerImageRepository(instance.getPublicDockerImageRepository());
        this.withTags(instance.getTags());
    }

    @Override
    public String getDockerImageRepository() {
        return this.dockerImageRepository;
    }

    @Override
    public A withDockerImageRepository(String dockerImageRepository) {
        this.dockerImageRepository = dockerImageRepository;
        return (A)this;
    }

    @Override
    public Boolean hasDockerImageRepository() {
        return this.dockerImageRepository != null;
    }

    @Override
    public String getPublicDockerImageRepository() {
        return this.publicDockerImageRepository;
    }

    @Override
    public A withPublicDockerImageRepository(String publicDockerImageRepository) {
        this.publicDockerImageRepository = publicDockerImageRepository;
        return (A)this;
    }

    @Override
    public Boolean hasPublicDockerImageRepository() {
        return this.publicDockerImageRepository != null;
    }

    @Override
    public A addToTags(int index, NamedTagEventList item) {
        if (this.tags == null) {
            this.tags = new ArrayList<NamedTagEventListBuilder>();
        }
        NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.tags.add(index >= 0 ? index : this.tags.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTags(int index, NamedTagEventList item) {
        if (this.tags == null) {
            this.tags = new ArrayList<NamedTagEventListBuilder>();
        }
        NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.tags.size()) {
            this.tags.add(builder);
        } else {
            this.tags.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTags(NamedTagEventList ... items) {
        if (this.tags == null) {
            this.tags = new ArrayList<NamedTagEventListBuilder>();
        }
        for (NamedTagEventList item : items) {
            NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
            this._visitables.add(builder);
            this.tags.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTags(Collection<NamedTagEventList> items) {
        if (this.tags == null) {
            this.tags = new ArrayList<NamedTagEventListBuilder>();
        }
        for (NamedTagEventList item : items) {
            NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
            this._visitables.add(builder);
            this.tags.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTags(NamedTagEventList ... items) {
        for (NamedTagEventList item : items) {
            NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
            this._visitables.remove(builder);
            if (this.tags == null) continue;
            this.tags.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTags(Collection<NamedTagEventList> items) {
        for (NamedTagEventList item : items) {
            NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
            this._visitables.remove(builder);
            if (this.tags == null) continue;
            this.tags.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NamedTagEventList> getTags() {
        return ImageStreamStatusFluentImpl.build(this.tags);
    }

    @Override
    public List<NamedTagEventList> buildTags() {
        return ImageStreamStatusFluentImpl.build(this.tags);
    }

    @Override
    public NamedTagEventList buildTag(int index) {
        return this.tags.get(index).build();
    }

    @Override
    public NamedTagEventList buildFirstTag() {
        return this.tags.get(0).build();
    }

    @Override
    public NamedTagEventList buildLastTag() {
        return this.tags.get(this.tags.size() - 1).build();
    }

    @Override
    public NamedTagEventList buildMatchingTag(Predicate<NamedTagEventListBuilder> predicate) {
        for (NamedTagEventListBuilder item : this.tags) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withTags(List<NamedTagEventList> tags) {
        if (this.tags == null) {
            this.tags = new ArrayList<NamedTagEventListBuilder>();
        } else {
            this._visitables.removeAll(this.tags);
            this.tags.clear();
        }
        if (tags != null) {
            for (NamedTagEventList item : tags) {
                this.addToTags(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withTags(NamedTagEventList ... tags) {
        this.tags.clear();
        if (tags != null) {
            for (NamedTagEventList item : tags) {
                this.addToTags(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    @Override
    public ImageStreamStatusFluent.TagsNested<A> addNewTag() {
        return new TagsNestedImpl();
    }

    @Override
    public ImageStreamStatusFluent.TagsNested<A> addNewTagLike(NamedTagEventList item) {
        return new TagsNestedImpl(-1, item);
    }

    @Override
    public ImageStreamStatusFluent.TagsNested<A> setNewTagLike(int index, NamedTagEventList item) {
        return new TagsNestedImpl(index, item);
    }

    @Override
    public ImageStreamStatusFluent.TagsNested<A> editTag(int index) {
        if (this.tags.size() <= index) {
            throw new RuntimeException("Can't edit tags. Index exceeds size.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    @Override
    public ImageStreamStatusFluent.TagsNested<A> editFirstTag() {
        if (this.tags.size() == 0) {
            throw new RuntimeException("Can't edit first tags. The list is empty.");
        }
        return this.setNewTagLike(0, this.buildTag(0));
    }

    @Override
    public ImageStreamStatusFluent.TagsNested<A> editLastTag() {
        int index = this.tags.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tags. The list is empty.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    @Override
    public ImageStreamStatusFluent.TagsNested<A> editMatchingTag(Predicate<NamedTagEventListBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tags.size(); ++i) {
            if (!predicate.apply(this.tags.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tags. No match found.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamStatusFluentImpl that = (ImageStreamStatusFluentImpl)o;
        if (this.dockerImageRepository != null ? !this.dockerImageRepository.equals(that.dockerImageRepository) : that.dockerImageRepository != null) {
            return false;
        }
        if (this.publicDockerImageRepository != null ? !this.publicDockerImageRepository.equals(that.publicDockerImageRepository) : that.publicDockerImageRepository != null) {
            return false;
        }
        return !(this.tags != null ? !this.tags.equals(that.tags) : that.tags != null);
    }

    public class TagsNestedImpl<N>
    extends NamedTagEventListFluentImpl<ImageStreamStatusFluent.TagsNested<N>>
    implements ImageStreamStatusFluent.TagsNested<N>,
    Nested<N> {
        private final NamedTagEventListBuilder builder;
        private final int index;

        TagsNestedImpl(int index, NamedTagEventList item) {
            this.index = index;
            this.builder = new NamedTagEventListBuilder(this, item);
        }

        TagsNestedImpl() {
            this.index = -1;
            this.builder = new NamedTagEventListBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamStatusFluentImpl.this.setToTags(this.index, this.builder.build());
        }

        @Override
        public N endTag() {
            return this.and();
        }
    }
}

