/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.DockerBuildStrategy;
import io.fabric8.openshift.api.model.DockerBuildStrategyFluent;
import io.fabric8.openshift.api.model.EditableDockerBuildStrategy;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DockerBuildStrategyBuilder
extends DockerBuildStrategyFluent<DockerBuildStrategyBuilder>
implements VisitableBuilder<DockerBuildStrategy, DockerBuildStrategyBuilder> {
    DockerBuildStrategyFluent<?> fluent;

    public DockerBuildStrategyBuilder() {
        this(new DockerBuildStrategy());
    }

    public DockerBuildStrategyBuilder(DockerBuildStrategyFluent<?> fluent) {
        this(fluent, new DockerBuildStrategy());
    }

    public DockerBuildStrategyBuilder(DockerBuildStrategyFluent<?> fluent, DockerBuildStrategy instance) {
        this.fluent = fluent;
        fluent.withEnv(instance.getEnv());
        fluent.withForcePull(instance.getForcePull());
        fluent.withFrom(instance.getFrom());
        fluent.withNoCache(instance.getNoCache());
        fluent.withPullSecret(instance.getPullSecret());
    }

    public DockerBuildStrategyBuilder(DockerBuildStrategy instance) {
        this.fluent = this;
        this.withEnv(instance.getEnv());
        this.withForcePull(instance.getForcePull());
        this.withFrom(instance.getFrom());
        this.withNoCache(instance.getNoCache());
        this.withPullSecret(instance.getPullSecret());
    }

    @Override
    public EditableDockerBuildStrategy build() {
        EditableDockerBuildStrategy buildable = new EditableDockerBuildStrategy(this.fluent.getEnv(), this.fluent.isForcePull(), this.fluent.getFrom(), this.fluent.isNoCache(), this.fluent.getPullSecret());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

