/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.GitRepoVolumeSource;
import io.fabric8.kubernetes.api.model.GitRepoVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSource;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.HostPathVolumeSource;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSource;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.NFSVolumeSource;
import io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.NFSVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.RBDVolumeSource;
import io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.RBDVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.SecretVolumeSourceFluent;
import java.util.HashMap;
import java.util.Map;

public class VolumeFluent<T extends VolumeFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    VisitableBuilder<AWSElasticBlockStoreVolumeSource, ?> awsElasticBlockStore;
    VisitableBuilder<EmptyDirVolumeSource, ?> emptyDir;
    VisitableBuilder<GCEPersistentDiskVolumeSource, ?> gcePersistentDisk;
    VisitableBuilder<GitRepoVolumeSource, ?> gitRepo;
    VisitableBuilder<GlusterfsVolumeSource, ?> glusterfs;
    VisitableBuilder<HostPathVolumeSource, ?> hostPath;
    VisitableBuilder<ISCSIVolumeSource, ?> iscsi;
    String name;
    VisitableBuilder<NFSVolumeSource, ?> nfs;
    PersistentVolumeClaimVolumeSource persistentVolumeClaim;
    VisitableBuilder<RBDVolumeSource, ?> rbd;
    VisitableBuilder<SecretVolumeSource, ?> secret;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore() {
        return this.awsElasticBlockStore != null ? (AWSElasticBlockStoreVolumeSource)this.awsElasticBlockStore.build() : null;
    }

    public T withAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore) {
        if (awsElasticBlockStore != null) {
            this.awsElasticBlockStore = new AWSElasticBlockStoreVolumeSourceBuilder(awsElasticBlockStore);
            this._visitables.add(this.awsElasticBlockStore);
        }
        return (T)this;
    }

    public AwsElasticBlockStoreNested<T> withNewAwsElasticBlockStore() {
        return new AwsElasticBlockStoreNested();
    }

    public AwsElasticBlockStoreNested<T> withNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item) {
        return new AwsElasticBlockStoreNested(item);
    }

    public AwsElasticBlockStoreNested<T> editAwsElasticBlockStore() {
        return this.withNewAwsElasticBlockStoreLike(this.getAwsElasticBlockStore());
    }

    public T withNewAwsElasticBlockStore(String fsType, Integer partition, Boolean readOnly, String volumeID) {
        return this.withAwsElasticBlockStore(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
    }

    public EmptyDirVolumeSource getEmptyDir() {
        return this.emptyDir != null ? (EmptyDirVolumeSource)this.emptyDir.build() : null;
    }

    public T withEmptyDir(EmptyDirVolumeSource emptyDir) {
        if (emptyDir != null) {
            this.emptyDir = new EmptyDirVolumeSourceBuilder(emptyDir);
            this._visitables.add(this.emptyDir);
        }
        return (T)this;
    }

    public EmptyDirNested<T> withNewEmptyDir() {
        return new EmptyDirNested();
    }

    public EmptyDirNested<T> withNewEmptyDirLike(EmptyDirVolumeSource item) {
        return new EmptyDirNested(item);
    }

    public EmptyDirNested<T> editEmptyDir() {
        return this.withNewEmptyDirLike(this.getEmptyDir());
    }

    public T withNewEmptyDir(String medium) {
        return this.withEmptyDir(new EmptyDirVolumeSource(medium));
    }

    public GCEPersistentDiskVolumeSource getGcePersistentDisk() {
        return this.gcePersistentDisk != null ? (GCEPersistentDiskVolumeSource)this.gcePersistentDisk.build() : null;
    }

    public T withGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk) {
        if (gcePersistentDisk != null) {
            this.gcePersistentDisk = new GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk);
            this._visitables.add(this.gcePersistentDisk);
        }
        return (T)this;
    }

    public GcePersistentDiskNested<T> withNewGcePersistentDisk() {
        return new GcePersistentDiskNested();
    }

    public GcePersistentDiskNested<T> withNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item) {
        return new GcePersistentDiskNested(item);
    }

    public GcePersistentDiskNested<T> editGcePersistentDisk() {
        return this.withNewGcePersistentDiskLike(this.getGcePersistentDisk());
    }

    public T withNewGcePersistentDisk(String fsType, Integer partition, String pdName, Boolean readOnly) {
        return this.withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
    }

    public GitRepoVolumeSource getGitRepo() {
        return this.gitRepo != null ? (GitRepoVolumeSource)this.gitRepo.build() : null;
    }

    public T withGitRepo(GitRepoVolumeSource gitRepo) {
        if (gitRepo != null) {
            this.gitRepo = new GitRepoVolumeSourceBuilder(gitRepo);
            this._visitables.add(this.gitRepo);
        }
        return (T)this;
    }

    public GitRepoNested<T> withNewGitRepo() {
        return new GitRepoNested();
    }

    public GitRepoNested<T> withNewGitRepoLike(GitRepoVolumeSource item) {
        return new GitRepoNested(item);
    }

    public GitRepoNested<T> editGitRepo() {
        return this.withNewGitRepoLike(this.getGitRepo());
    }

    public T withNewGitRepo(String repository, String revision) {
        return this.withGitRepo(new GitRepoVolumeSource(repository, revision));
    }

    public GlusterfsVolumeSource getGlusterfs() {
        return this.glusterfs != null ? (GlusterfsVolumeSource)this.glusterfs.build() : null;
    }

    public T withGlusterfs(GlusterfsVolumeSource glusterfs) {
        if (glusterfs != null) {
            this.glusterfs = new GlusterfsVolumeSourceBuilder(glusterfs);
            this._visitables.add(this.glusterfs);
        }
        return (T)this;
    }

    public GlusterfsNested<T> withNewGlusterfs() {
        return new GlusterfsNested();
    }

    public GlusterfsNested<T> withNewGlusterfsLike(GlusterfsVolumeSource item) {
        return new GlusterfsNested(item);
    }

    public GlusterfsNested<T> editGlusterfs() {
        return this.withNewGlusterfsLike(this.getGlusterfs());
    }

    public T withNewGlusterfs(String endpoints, String path, Boolean readOnly) {
        return this.withGlusterfs(new GlusterfsVolumeSource(endpoints, path, readOnly));
    }

    public HostPathVolumeSource getHostPath() {
        return this.hostPath != null ? (HostPathVolumeSource)this.hostPath.build() : null;
    }

    public T withHostPath(HostPathVolumeSource hostPath) {
        if (hostPath != null) {
            this.hostPath = new HostPathVolumeSourceBuilder(hostPath);
            this._visitables.add(this.hostPath);
        }
        return (T)this;
    }

    public HostPathNested<T> withNewHostPath() {
        return new HostPathNested();
    }

    public HostPathNested<T> withNewHostPathLike(HostPathVolumeSource item) {
        return new HostPathNested(item);
    }

    public HostPathNested<T> editHostPath() {
        return this.withNewHostPathLike(this.getHostPath());
    }

    public T withNewHostPath(String path) {
        return this.withHostPath(new HostPathVolumeSource(path));
    }

    public ISCSIVolumeSource getIscsi() {
        return this.iscsi != null ? (ISCSIVolumeSource)this.iscsi.build() : null;
    }

    public T withIscsi(ISCSIVolumeSource iscsi) {
        if (iscsi != null) {
            this.iscsi = new ISCSIVolumeSourceBuilder(iscsi);
            this._visitables.add(this.iscsi);
        }
        return (T)this;
    }

    public IscsiNested<T> withNewIscsi() {
        return new IscsiNested();
    }

    public IscsiNested<T> withNewIscsiLike(ISCSIVolumeSource item) {
        return new IscsiNested(item);
    }

    public IscsiNested<T> editIscsi() {
        return this.withNewIscsiLike(this.getIscsi());
    }

    public T withNewIscsi(String fsType, String iqn, Integer lun, Boolean readOnly, String targetPortal) {
        return this.withIscsi(new ISCSIVolumeSource(fsType, iqn, lun, readOnly, targetPortal));
    }

    public String getName() {
        return this.name;
    }

    public T withName(String name) {
        this.name = name;
        return (T)this;
    }

    public NFSVolumeSource getNfs() {
        return this.nfs != null ? (NFSVolumeSource)this.nfs.build() : null;
    }

    public T withNfs(NFSVolumeSource nfs) {
        if (nfs != null) {
            this.nfs = new NFSVolumeSourceBuilder(nfs);
            this._visitables.add(this.nfs);
        }
        return (T)this;
    }

    public NfsNested<T> withNewNfs() {
        return new NfsNested();
    }

    public NfsNested<T> withNewNfsLike(NFSVolumeSource item) {
        return new NfsNested(item);
    }

    public NfsNested<T> editNfs() {
        return this.withNewNfsLike(this.getNfs());
    }

    public T withNewNfs(String path, Boolean readOnly, String server) {
        return this.withNfs(new NFSVolumeSource(path, readOnly, server));
    }

    public PersistentVolumeClaimVolumeSource getPersistentVolumeClaim() {
        return this.persistentVolumeClaim;
    }

    public T withPersistentVolumeClaim(PersistentVolumeClaimVolumeSource persistentVolumeClaim) {
        this.persistentVolumeClaim = persistentVolumeClaim;
        return (T)this;
    }

    public RBDVolumeSource getRbd() {
        return this.rbd != null ? (RBDVolumeSource)this.rbd.build() : null;
    }

    public T withRbd(RBDVolumeSource rbd) {
        if (rbd != null) {
            this.rbd = new RBDVolumeSourceBuilder(rbd);
            this._visitables.add(this.rbd);
        }
        return (T)this;
    }

    public RbdNested<T> withNewRbd() {
        return new RbdNested();
    }

    public RbdNested<T> withNewRbdLike(RBDVolumeSource item) {
        return new RbdNested(item);
    }

    public RbdNested<T> editRbd() {
        return this.withNewRbdLike(this.getRbd());
    }

    public SecretVolumeSource getSecret() {
        return this.secret != null ? (SecretVolumeSource)this.secret.build() : null;
    }

    public T withSecret(SecretVolumeSource secret) {
        if (secret != null) {
            this.secret = new SecretVolumeSourceBuilder(secret);
            this._visitables.add(this.secret);
        }
        return (T)this;
    }

    public SecretNested<T> withNewSecret() {
        return new SecretNested();
    }

    public SecretNested<T> withNewSecretLike(SecretVolumeSource item) {
        return new SecretNested(item);
    }

    public SecretNested<T> editSecret() {
        return this.withNewSecretLike(this.getSecret());
    }

    public T withNewSecret(String secretName) {
        return this.withSecret(new SecretVolumeSource(secretName));
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public class SecretNested<N>
    extends SecretVolumeSourceFluent<SecretNested<N>>
    implements Nested<N> {
        private final SecretVolumeSourceBuilder builder;

        SecretNested() {
            this.builder = new SecretVolumeSourceBuilder(this);
        }

        SecretNested(SecretVolumeSource item) {
            this.builder = new SecretVolumeSourceBuilder(this, item);
        }

        public N endSecret() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)VolumeFluent.this.withSecret(this.builder.build());
        }
    }

    public class RbdNested<N>
    extends RBDVolumeSourceFluent<RbdNested<N>>
    implements Nested<N> {
        private final RBDVolumeSourceBuilder builder;

        RbdNested() {
            this.builder = new RBDVolumeSourceBuilder(this);
        }

        RbdNested(RBDVolumeSource item) {
            this.builder = new RBDVolumeSourceBuilder(this, item);
        }

        public N endRbd() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)VolumeFluent.this.withRbd(this.builder.build());
        }
    }

    public class NfsNested<N>
    extends NFSVolumeSourceFluent<NfsNested<N>>
    implements Nested<N> {
        private final NFSVolumeSourceBuilder builder;

        NfsNested() {
            this.builder = new NFSVolumeSourceBuilder(this);
        }

        NfsNested(NFSVolumeSource item) {
            this.builder = new NFSVolumeSourceBuilder(this, item);
        }

        public N endNfs() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)VolumeFluent.this.withNfs(this.builder.build());
        }
    }

    public class IscsiNested<N>
    extends ISCSIVolumeSourceFluent<IscsiNested<N>>
    implements Nested<N> {
        private final ISCSIVolumeSourceBuilder builder;

        IscsiNested() {
            this.builder = new ISCSIVolumeSourceBuilder(this);
        }

        IscsiNested(ISCSIVolumeSource item) {
            this.builder = new ISCSIVolumeSourceBuilder(this, item);
        }

        public N endIscsi() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)VolumeFluent.this.withIscsi(this.builder.build());
        }
    }

    public class HostPathNested<N>
    extends HostPathVolumeSourceFluent<HostPathNested<N>>
    implements Nested<N> {
        private final HostPathVolumeSourceBuilder builder;

        HostPathNested() {
            this.builder = new HostPathVolumeSourceBuilder(this);
        }

        HostPathNested(HostPathVolumeSource item) {
            this.builder = new HostPathVolumeSourceBuilder(this, item);
        }

        public N endHostPath() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)VolumeFluent.this.withHostPath(this.builder.build());
        }
    }

    public class GlusterfsNested<N>
    extends GlusterfsVolumeSourceFluent<GlusterfsNested<N>>
    implements Nested<N> {
        private final GlusterfsVolumeSourceBuilder builder;

        GlusterfsNested() {
            this.builder = new GlusterfsVolumeSourceBuilder(this);
        }

        GlusterfsNested(GlusterfsVolumeSource item) {
            this.builder = new GlusterfsVolumeSourceBuilder(this, item);
        }

        public N endGlusterfs() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)VolumeFluent.this.withGlusterfs(this.builder.build());
        }
    }

    public class GitRepoNested<N>
    extends GitRepoVolumeSourceFluent<GitRepoNested<N>>
    implements Nested<N> {
        private final GitRepoVolumeSourceBuilder builder;

        GitRepoNested() {
            this.builder = new GitRepoVolumeSourceBuilder(this);
        }

        GitRepoNested(GitRepoVolumeSource item) {
            this.builder = new GitRepoVolumeSourceBuilder(this, item);
        }

        public N endGitRepo() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)VolumeFluent.this.withGitRepo(this.builder.build());
        }
    }

    public class GcePersistentDiskNested<N>
    extends GCEPersistentDiskVolumeSourceFluent<GcePersistentDiskNested<N>>
    implements Nested<N> {
        private final GCEPersistentDiskVolumeSourceBuilder builder;

        GcePersistentDiskNested() {
            this.builder = new GCEPersistentDiskVolumeSourceBuilder(this);
        }

        GcePersistentDiskNested(GCEPersistentDiskVolumeSource item) {
            this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
        }

        public N endGcePersistentDisk() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)VolumeFluent.this.withGcePersistentDisk(this.builder.build());
        }
    }

    public class EmptyDirNested<N>
    extends EmptyDirVolumeSourceFluent<EmptyDirNested<N>>
    implements Nested<N> {
        private final EmptyDirVolumeSourceBuilder builder;

        EmptyDirNested() {
            this.builder = new EmptyDirVolumeSourceBuilder(this);
        }

        EmptyDirNested(EmptyDirVolumeSource item) {
            this.builder = new EmptyDirVolumeSourceBuilder(this, item);
        }

        public N endEmptyDir() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)VolumeFluent.this.withEmptyDir(this.builder.build());
        }
    }

    public class AwsElasticBlockStoreNested<N>
    extends AWSElasticBlockStoreVolumeSourceFluent<AwsElasticBlockStoreNested<N>>
    implements Nested<N> {
        private final AWSElasticBlockStoreVolumeSourceBuilder builder;

        AwsElasticBlockStoreNested() {
            this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this);
        }

        AwsElasticBlockStoreNested(AWSElasticBlockStoreVolumeSource item) {
            this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
        }

        public N endAwsElasticBlockStore() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)VolumeFluent.this.withAwsElasticBlockStore(this.builder.build());
        }
    }
}

