/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.CephFSVolumeSource;
import io.fabric8.kubernetes.api.model.CephFSVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSource;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.HostPathVolumeSource;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSource;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.NFSVolumeSource;
import io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.NFSVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.RBDVolumeSource;
import io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.RBDVolumeSourceFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PersistentVolumeSpecFluent<T extends PersistentVolumeSpecFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    List<String> accessModes = new ArrayList<String>();
    VisitableBuilder<AWSElasticBlockStoreVolumeSource, ?> awsElasticBlockStore;
    Map<String, Quantity> capacity = new HashMap<String, Quantity>();
    VisitableBuilder<CephFSVolumeSource, ?> cephfs;
    VisitableBuilder<ObjectReference, ?> claimRef;
    VisitableBuilder<GCEPersistentDiskVolumeSource, ?> gcePersistentDisk;
    VisitableBuilder<GlusterfsVolumeSource, ?> glusterfs;
    VisitableBuilder<HostPathVolumeSource, ?> hostPath;
    VisitableBuilder<ISCSIVolumeSource, ?> iscsi;
    VisitableBuilder<NFSVolumeSource, ?> nfs;
    String persistentVolumeReclaimPolicy;
    VisitableBuilder<RBDVolumeSource, ?> rbd;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public T addToAccessModes(String ... items) {
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (T)this;
    }

    public T removeFromAccessModes(String ... items) {
        for (String item : items) {
            this.accessModes.remove(item);
        }
        return (T)this;
    }

    public List<String> getAccessModes() {
        return this.accessModes;
    }

    public T withAccessModes(List<String> accessModes) {
        this.accessModes.clear();
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (T)this;
    }

    public T withAccessModes(String ... accessModes) {
        this.accessModes.clear();
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (T)this;
    }

    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore() {
        return this.awsElasticBlockStore != null ? (AWSElasticBlockStoreVolumeSource)this.awsElasticBlockStore.build() : null;
    }

    public T withAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore) {
        if (awsElasticBlockStore != null) {
            this.awsElasticBlockStore = new AWSElasticBlockStoreVolumeSourceBuilder(awsElasticBlockStore);
            this._visitables.add(this.awsElasticBlockStore);
        }
        return (T)this;
    }

    public AwsElasticBlockStoreNested<T> withNewAwsElasticBlockStore() {
        return new AwsElasticBlockStoreNested();
    }

    public AwsElasticBlockStoreNested<T> withNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item) {
        return new AwsElasticBlockStoreNested(item);
    }

    public AwsElasticBlockStoreNested<T> editAwsElasticBlockStore() {
        return this.withNewAwsElasticBlockStoreLike(this.getAwsElasticBlockStore());
    }

    public T withNewAwsElasticBlockStore(String fsType, Integer partition, Boolean readOnly, String volumeID) {
        return this.withAwsElasticBlockStore(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
    }

    public T addToCapacity(String key, Quantity value) {
        if (key != null && value != null) {
            this.capacity.put(key, value);
        }
        return (T)this;
    }

    public T removeFromCapacity(String key) {
        if (key != null) {
            this.capacity.remove(key);
        }
        return (T)this;
    }

    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    public T withCapacity(Map<String, Quantity> capacity) {
        this.capacity.clear();
        if (capacity != null) {
            this.capacity.putAll(capacity);
        }
        return (T)this;
    }

    public CephFSVolumeSource getCephfs() {
        return this.cephfs != null ? (CephFSVolumeSource)this.cephfs.build() : null;
    }

    public T withCephfs(CephFSVolumeSource cephfs) {
        if (cephfs != null) {
            this.cephfs = new CephFSVolumeSourceBuilder(cephfs);
            this._visitables.add(this.cephfs);
        }
        return (T)this;
    }

    public CephfsNested<T> withNewCephfs() {
        return new CephfsNested();
    }

    public CephfsNested<T> withNewCephfsLike(CephFSVolumeSource item) {
        return new CephfsNested(item);
    }

    public CephfsNested<T> editCephfs() {
        return this.withNewCephfsLike(this.getCephfs());
    }

    public ObjectReference getClaimRef() {
        return this.claimRef != null ? (ObjectReference)this.claimRef.build() : null;
    }

    public T withClaimRef(ObjectReference claimRef) {
        if (claimRef != null) {
            this.claimRef = new ObjectReferenceBuilder(claimRef);
            this._visitables.add(this.claimRef);
        }
        return (T)this;
    }

    public ClaimRefNested<T> withNewClaimRef() {
        return new ClaimRefNested();
    }

    public ClaimRefNested<T> withNewClaimRefLike(ObjectReference item) {
        return new ClaimRefNested(item);
    }

    public ClaimRefNested<T> editClaimRef() {
        return this.withNewClaimRefLike(this.getClaimRef());
    }

    public GCEPersistentDiskVolumeSource getGcePersistentDisk() {
        return this.gcePersistentDisk != null ? (GCEPersistentDiskVolumeSource)this.gcePersistentDisk.build() : null;
    }

    public T withGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk) {
        if (gcePersistentDisk != null) {
            this.gcePersistentDisk = new GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk);
            this._visitables.add(this.gcePersistentDisk);
        }
        return (T)this;
    }

    public GcePersistentDiskNested<T> withNewGcePersistentDisk() {
        return new GcePersistentDiskNested();
    }

    public GcePersistentDiskNested<T> withNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item) {
        return new GcePersistentDiskNested(item);
    }

    public GcePersistentDiskNested<T> editGcePersistentDisk() {
        return this.withNewGcePersistentDiskLike(this.getGcePersistentDisk());
    }

    public T withNewGcePersistentDisk(String fsType, Integer partition, String pdName, Boolean readOnly) {
        return this.withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
    }

    public GlusterfsVolumeSource getGlusterfs() {
        return this.glusterfs != null ? (GlusterfsVolumeSource)this.glusterfs.build() : null;
    }

    public T withGlusterfs(GlusterfsVolumeSource glusterfs) {
        if (glusterfs != null) {
            this.glusterfs = new GlusterfsVolumeSourceBuilder(glusterfs);
            this._visitables.add(this.glusterfs);
        }
        return (T)this;
    }

    public GlusterfsNested<T> withNewGlusterfs() {
        return new GlusterfsNested();
    }

    public GlusterfsNested<T> withNewGlusterfsLike(GlusterfsVolumeSource item) {
        return new GlusterfsNested(item);
    }

    public GlusterfsNested<T> editGlusterfs() {
        return this.withNewGlusterfsLike(this.getGlusterfs());
    }

    public T withNewGlusterfs(String endpoints, String path, Boolean readOnly) {
        return this.withGlusterfs(new GlusterfsVolumeSource(endpoints, path, readOnly));
    }

    public HostPathVolumeSource getHostPath() {
        return this.hostPath != null ? (HostPathVolumeSource)this.hostPath.build() : null;
    }

    public T withHostPath(HostPathVolumeSource hostPath) {
        if (hostPath != null) {
            this.hostPath = new HostPathVolumeSourceBuilder(hostPath);
            this._visitables.add(this.hostPath);
        }
        return (T)this;
    }

    public HostPathNested<T> withNewHostPath() {
        return new HostPathNested();
    }

    public HostPathNested<T> withNewHostPathLike(HostPathVolumeSource item) {
        return new HostPathNested(item);
    }

    public HostPathNested<T> editHostPath() {
        return this.withNewHostPathLike(this.getHostPath());
    }

    public T withNewHostPath(String path) {
        return this.withHostPath(new HostPathVolumeSource(path));
    }

    public ISCSIVolumeSource getIscsi() {
        return this.iscsi != null ? (ISCSIVolumeSource)this.iscsi.build() : null;
    }

    public T withIscsi(ISCSIVolumeSource iscsi) {
        if (iscsi != null) {
            this.iscsi = new ISCSIVolumeSourceBuilder(iscsi);
            this._visitables.add(this.iscsi);
        }
        return (T)this;
    }

    public IscsiNested<T> withNewIscsi() {
        return new IscsiNested();
    }

    public IscsiNested<T> withNewIscsiLike(ISCSIVolumeSource item) {
        return new IscsiNested(item);
    }

    public IscsiNested<T> editIscsi() {
        return this.withNewIscsiLike(this.getIscsi());
    }

    public T withNewIscsi(String fsType, String iqn, Integer lun, Boolean readOnly, String targetPortal) {
        return this.withIscsi(new ISCSIVolumeSource(fsType, iqn, lun, readOnly, targetPortal));
    }

    public NFSVolumeSource getNfs() {
        return this.nfs != null ? (NFSVolumeSource)this.nfs.build() : null;
    }

    public T withNfs(NFSVolumeSource nfs) {
        if (nfs != null) {
            this.nfs = new NFSVolumeSourceBuilder(nfs);
            this._visitables.add(this.nfs);
        }
        return (T)this;
    }

    public NfsNested<T> withNewNfs() {
        return new NfsNested();
    }

    public NfsNested<T> withNewNfsLike(NFSVolumeSource item) {
        return new NfsNested(item);
    }

    public NfsNested<T> editNfs() {
        return this.withNewNfsLike(this.getNfs());
    }

    public T withNewNfs(String path, Boolean readOnly, String server) {
        return this.withNfs(new NFSVolumeSource(path, readOnly, server));
    }

    public String getPersistentVolumeReclaimPolicy() {
        return this.persistentVolumeReclaimPolicy;
    }

    public T withPersistentVolumeReclaimPolicy(String persistentVolumeReclaimPolicy) {
        this.persistentVolumeReclaimPolicy = persistentVolumeReclaimPolicy;
        return (T)this;
    }

    public RBDVolumeSource getRbd() {
        return this.rbd != null ? (RBDVolumeSource)this.rbd.build() : null;
    }

    public T withRbd(RBDVolumeSource rbd) {
        if (rbd != null) {
            this.rbd = new RBDVolumeSourceBuilder(rbd);
            this._visitables.add(this.rbd);
        }
        return (T)this;
    }

    public RbdNested<T> withNewRbd() {
        return new RbdNested();
    }

    public RbdNested<T> withNewRbdLike(RBDVolumeSource item) {
        return new RbdNested(item);
    }

    public RbdNested<T> editRbd() {
        return this.withNewRbdLike(this.getRbd());
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentVolumeSpecFluent that = (PersistentVolumeSpecFluent)o;
        if (this.accessModes != null ? !this.accessModes.equals(that.accessModes) : that.accessModes != null) {
            return false;
        }
        if (this.awsElasticBlockStore != null ? !this.awsElasticBlockStore.equals(that.awsElasticBlockStore) : that.awsElasticBlockStore != null) {
            return false;
        }
        if (this.capacity != null ? !this.capacity.equals(that.capacity) : that.capacity != null) {
            return false;
        }
        if (this.cephfs != null ? !this.cephfs.equals(that.cephfs) : that.cephfs != null) {
            return false;
        }
        if (this.claimRef != null ? !this.claimRef.equals(that.claimRef) : that.claimRef != null) {
            return false;
        }
        if (this.gcePersistentDisk != null ? !this.gcePersistentDisk.equals(that.gcePersistentDisk) : that.gcePersistentDisk != null) {
            return false;
        }
        if (this.glusterfs != null ? !this.glusterfs.equals(that.glusterfs) : that.glusterfs != null) {
            return false;
        }
        if (this.hostPath != null ? !this.hostPath.equals(that.hostPath) : that.hostPath != null) {
            return false;
        }
        if (this.iscsi != null ? !this.iscsi.equals(that.iscsi) : that.iscsi != null) {
            return false;
        }
        if (this.nfs != null ? !this.nfs.equals(that.nfs) : that.nfs != null) {
            return false;
        }
        if (this.persistentVolumeReclaimPolicy != null ? !this.persistentVolumeReclaimPolicy.equals(that.persistentVolumeReclaimPolicy) : that.persistentVolumeReclaimPolicy != null) {
            return false;
        }
        if (this.rbd != null ? !this.rbd.equals(that.rbd) : that.rbd != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class RbdNested<N>
    extends RBDVolumeSourceFluent<RbdNested<N>>
    implements Nested<N> {
        private final RBDVolumeSourceBuilder builder;

        RbdNested() {
            this.builder = new RBDVolumeSourceBuilder(this);
        }

        RbdNested(RBDVolumeSource item) {
            this.builder = new RBDVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluent.this.withRbd(this.builder.build());
        }

        public N endRbd() {
            return this.and();
        }
    }

    public class NfsNested<N>
    extends NFSVolumeSourceFluent<NfsNested<N>>
    implements Nested<N> {
        private final NFSVolumeSourceBuilder builder;

        NfsNested() {
            this.builder = new NFSVolumeSourceBuilder(this);
        }

        NfsNested(NFSVolumeSource item) {
            this.builder = new NFSVolumeSourceBuilder(this, item);
        }

        public N endNfs() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluent.this.withNfs(this.builder.build());
        }
    }

    public class IscsiNested<N>
    extends ISCSIVolumeSourceFluent<IscsiNested<N>>
    implements Nested<N> {
        private final ISCSIVolumeSourceBuilder builder;

        IscsiNested() {
            this.builder = new ISCSIVolumeSourceBuilder(this);
        }

        IscsiNested(ISCSIVolumeSource item) {
            this.builder = new ISCSIVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluent.this.withIscsi(this.builder.build());
        }

        public N endIscsi() {
            return this.and();
        }
    }

    public class HostPathNested<N>
    extends HostPathVolumeSourceFluent<HostPathNested<N>>
    implements Nested<N> {
        private final HostPathVolumeSourceBuilder builder;

        HostPathNested() {
            this.builder = new HostPathVolumeSourceBuilder(this);
        }

        HostPathNested(HostPathVolumeSource item) {
            this.builder = new HostPathVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluent.this.withHostPath(this.builder.build());
        }

        public N endHostPath() {
            return this.and();
        }
    }

    public class GlusterfsNested<N>
    extends GlusterfsVolumeSourceFluent<GlusterfsNested<N>>
    implements Nested<N> {
        private final GlusterfsVolumeSourceBuilder builder;

        GlusterfsNested() {
            this.builder = new GlusterfsVolumeSourceBuilder(this);
        }

        GlusterfsNested(GlusterfsVolumeSource item) {
            this.builder = new GlusterfsVolumeSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluent.this.withGlusterfs(this.builder.build());
        }

        public N endGlusterfs() {
            return this.and();
        }
    }

    public class GcePersistentDiskNested<N>
    extends GCEPersistentDiskVolumeSourceFluent<GcePersistentDiskNested<N>>
    implements Nested<N> {
        private final GCEPersistentDiskVolumeSourceBuilder builder;

        GcePersistentDiskNested() {
            this.builder = new GCEPersistentDiskVolumeSourceBuilder(this);
        }

        GcePersistentDiskNested(GCEPersistentDiskVolumeSource item) {
            this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
        }

        public N endGcePersistentDisk() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluent.this.withGcePersistentDisk(this.builder.build());
        }
    }

    public class ClaimRefNested<N>
    extends ObjectReferenceFluent<ClaimRefNested<N>>
    implements Nested<N> {
        private final ObjectReferenceBuilder builder;

        ClaimRefNested() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        ClaimRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluent.this.withClaimRef(this.builder.build());
        }

        public N endClaimRef() {
            return this.and();
        }
    }

    public class CephfsNested<N>
    extends CephFSVolumeSourceFluent<CephfsNested<N>>
    implements Nested<N> {
        private final CephFSVolumeSourceBuilder builder;

        CephfsNested() {
            this.builder = new CephFSVolumeSourceBuilder(this);
        }

        CephfsNested(CephFSVolumeSource item) {
            this.builder = new CephFSVolumeSourceBuilder(this, item);
        }

        public N endCephfs() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluent.this.withCephfs(this.builder.build());
        }
    }

    public class AwsElasticBlockStoreNested<N>
    extends AWSElasticBlockStoreVolumeSourceFluent<AwsElasticBlockStoreNested<N>>
    implements Nested<N> {
        private final AWSElasticBlockStoreVolumeSourceBuilder builder;

        AwsElasticBlockStoreNested() {
            this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this);
        }

        AwsElasticBlockStoreNested(AWSElasticBlockStoreVolumeSource item) {
            this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
        }

        public N endAwsElasticBlockStore() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluent.this.withAwsElasticBlockStore(this.builder.build());
        }
    }
}

