/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import java.util.HashMap;
import java.util.Map;

public class ServicePortFluent<T extends ServicePortFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    String name;
    Integer nodePort;
    Integer port;
    String protocol;
    VisitableBuilder<IntOrString, ?> targetPort;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public String getName() {
        return this.name;
    }

    public T withName(String name) {
        this.name = name;
        return (T)this;
    }

    public Integer getNodePort() {
        return this.nodePort;
    }

    public T withNodePort(Integer nodePort) {
        this.nodePort = nodePort;
        return (T)this;
    }

    public Integer getPort() {
        return this.port;
    }

    public T withPort(Integer port) {
        this.port = port;
        return (T)this;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public T withProtocol(String protocol) {
        this.protocol = protocol;
        return (T)this;
    }

    public IntOrString getTargetPort() {
        return this.targetPort != null ? (IntOrString)this.targetPort.build() : null;
    }

    public T withTargetPort(IntOrString targetPort) {
        if (targetPort != null) {
            this.targetPort = new IntOrStringBuilder(targetPort);
            this._visitables.add(this.targetPort);
        }
        return (T)this;
    }

    public TargetPortNested<T> withNewTargetPort() {
        return new TargetPortNested();
    }

    public TargetPortNested<T> withNewTargetPortLike(IntOrString item) {
        return new TargetPortNested(item);
    }

    public TargetPortNested<T> editTargetPort() {
        return this.withNewTargetPortLike(this.getTargetPort());
    }

    public T withNewTargetPort(String strVal) {
        return this.withTargetPort(new IntOrString(strVal));
    }

    public T withNewTargetPort(Integer intVal) {
        return this.withTargetPort(new IntOrString(intVal));
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServicePortFluent that = (ServicePortFluent)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.nodePort != null ? !this.nodePort.equals(that.nodePort) : that.nodePort != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) {
            return false;
        }
        if (this.targetPort != null ? !this.targetPort.equals(that.targetPort) : that.targetPort != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class TargetPortNested<N>
    extends IntOrStringFluent<TargetPortNested<N>>
    implements Nested<N> {
        private final IntOrStringBuilder builder;

        TargetPortNested() {
            this.builder = new IntOrStringBuilder(this);
        }

        TargetPortNested(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        public N endTargetPort() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ServicePortFluent.this.withTargetPort(this.builder.build());
        }
    }
}

