/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.rbac.Role;
import io.fabric8.kubernetes.api.model.rbac.RoleFluent;
import io.fabric8.kubernetes.api.model.rbac.RoleFluentImpl;
import java.util.Objects;

public class RoleBuilder
extends RoleFluentImpl<RoleBuilder>
implements VisitableBuilder<Role, RoleBuilder> {
    RoleFluent<?> fluent;
    Boolean validationEnabled;

    public RoleBuilder() {
        this(false);
    }

    public RoleBuilder(Boolean validationEnabled) {
        this(new Role(), validationEnabled);
    }

    public RoleBuilder(RoleFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public RoleBuilder(RoleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Role(), validationEnabled);
    }

    public RoleBuilder(RoleFluent<?> fluent, Role instance) {
        this(fluent, instance, false);
    }

    public RoleBuilder(RoleFluent<?> fluent, Role instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRules(instance.getRules());
        this.validationEnabled = validationEnabled;
    }

    public RoleBuilder(Role instance) {
        this(instance, (Boolean)false);
    }

    public RoleBuilder(Role instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRules(instance.getRules());
        this.validationEnabled = validationEnabled;
    }

    public Role build() {
        Role buildable = new Role(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getRules());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RoleBuilder that = (RoleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

