/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.policy;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.policy.IDRange;
import io.fabric8.kubernetes.api.model.policy.IDRangeBuilder;
import io.fabric8.kubernetes.api.model.policy.IDRangeFluentImpl;
import io.fabric8.kubernetes.api.model.policy.RunAsUserStrategyOptions;
import io.fabric8.kubernetes.api.model.policy.RunAsUserStrategyOptionsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class RunAsUserStrategyOptionsFluentImpl<A extends RunAsUserStrategyOptionsFluent<A>>
extends BaseFluent<A>
implements RunAsUserStrategyOptionsFluent<A> {
    private List<IDRangeBuilder> ranges = new ArrayList<IDRangeBuilder>();
    private String rule;

    public RunAsUserStrategyOptionsFluentImpl() {
    }

    public RunAsUserStrategyOptionsFluentImpl(RunAsUserStrategyOptions instance) {
        this.withRanges(instance.getRanges());
        this.withRule(instance.getRule());
    }

    @Override
    public A addToRanges(int index, IDRange item) {
        if (this.ranges == null) {
            this.ranges = new ArrayList<IDRangeBuilder>();
        }
        IDRangeBuilder builder = new IDRangeBuilder(item);
        this._visitables.get((Object)"ranges").add(index >= 0 ? index : this._visitables.get((Object)"ranges").size(), builder);
        this.ranges.add(index >= 0 ? index : this.ranges.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRanges(int index, IDRange item) {
        if (this.ranges == null) {
            this.ranges = new ArrayList<IDRangeBuilder>();
        }
        IDRangeBuilder builder = new IDRangeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"ranges").size()) {
            this._visitables.get((Object)"ranges").add(builder);
        } else {
            this._visitables.get((Object)"ranges").set(index, builder);
        }
        if (index < 0 || index >= this.ranges.size()) {
            this.ranges.add(builder);
        } else {
            this.ranges.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRanges(IDRange ... items) {
        if (this.ranges == null) {
            this.ranges = new ArrayList<IDRangeBuilder>();
        }
        for (IDRange item : items) {
            IDRangeBuilder builder = new IDRangeBuilder(item);
            this._visitables.get((Object)"ranges").add(builder);
            this.ranges.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRanges(Collection<IDRange> items) {
        if (this.ranges == null) {
            this.ranges = new ArrayList<IDRangeBuilder>();
        }
        for (IDRange item : items) {
            IDRangeBuilder builder = new IDRangeBuilder(item);
            this._visitables.get((Object)"ranges").add(builder);
            this.ranges.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRanges(IDRange ... items) {
        for (IDRange item : items) {
            IDRangeBuilder builder = new IDRangeBuilder(item);
            this._visitables.get((Object)"ranges").remove(builder);
            if (this.ranges == null) continue;
            this.ranges.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRanges(Collection<IDRange> items) {
        for (IDRange item : items) {
            IDRangeBuilder builder = new IDRangeBuilder(item);
            this._visitables.get((Object)"ranges").remove(builder);
            if (this.ranges == null) continue;
            this.ranges.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRanges(Predicate<IDRangeBuilder> predicate) {
        if (this.ranges == null) {
            return (A)this;
        }
        Iterator<IDRangeBuilder> each = this.ranges.iterator();
        List visitables = this._visitables.get((Object)"ranges");
        while (each.hasNext()) {
            IDRangeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<IDRange> getRanges() {
        return RunAsUserStrategyOptionsFluentImpl.build(this.ranges);
    }

    @Override
    public List<IDRange> buildRanges() {
        return RunAsUserStrategyOptionsFluentImpl.build(this.ranges);
    }

    @Override
    public IDRange buildRange(int index) {
        return this.ranges.get(index).build();
    }

    @Override
    public IDRange buildFirstRange() {
        return this.ranges.get(0).build();
    }

    @Override
    public IDRange buildLastRange() {
        return this.ranges.get(this.ranges.size() - 1).build();
    }

    @Override
    public IDRange buildMatchingRange(Predicate<IDRangeBuilder> predicate) {
        for (IDRangeBuilder item : this.ranges) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRange(Predicate<IDRangeBuilder> predicate) {
        for (IDRangeBuilder item : this.ranges) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRanges(List<IDRange> ranges) {
        if (this.ranges != null) {
            this._visitables.get((Object)"ranges").removeAll(this.ranges);
        }
        if (ranges != null) {
            this.ranges = new ArrayList<IDRangeBuilder>();
            for (IDRange item : ranges) {
                this.addToRanges(item);
            }
        } else {
            this.ranges = null;
        }
        return (A)this;
    }

    @Override
    public A withRanges(IDRange ... ranges) {
        if (this.ranges != null) {
            this.ranges.clear();
        }
        if (ranges != null) {
            for (IDRange item : ranges) {
                this.addToRanges(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRanges() {
        return this.ranges != null && !this.ranges.isEmpty();
    }

    @Override
    public A addNewRange(Long max, Long min) {
        return this.addToRanges(new IDRange(max, min));
    }

    @Override
    public RunAsUserStrategyOptionsFluent.RangesNested<A> addNewRange() {
        return new RangesNestedImpl();
    }

    @Override
    public RunAsUserStrategyOptionsFluent.RangesNested<A> addNewRangeLike(IDRange item) {
        return new RangesNestedImpl(-1, item);
    }

    @Override
    public RunAsUserStrategyOptionsFluent.RangesNested<A> setNewRangeLike(int index, IDRange item) {
        return new RangesNestedImpl(index, item);
    }

    @Override
    public RunAsUserStrategyOptionsFluent.RangesNested<A> editRange(int index) {
        if (this.ranges.size() <= index) {
            throw new RuntimeException("Can't edit ranges. Index exceeds size.");
        }
        return this.setNewRangeLike(index, this.buildRange(index));
    }

    @Override
    public RunAsUserStrategyOptionsFluent.RangesNested<A> editFirstRange() {
        if (this.ranges.size() == 0) {
            throw new RuntimeException("Can't edit first ranges. The list is empty.");
        }
        return this.setNewRangeLike(0, this.buildRange(0));
    }

    @Override
    public RunAsUserStrategyOptionsFluent.RangesNested<A> editLastRange() {
        int index = this.ranges.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ranges. The list is empty.");
        }
        return this.setNewRangeLike(index, this.buildRange(index));
    }

    @Override
    public RunAsUserStrategyOptionsFluent.RangesNested<A> editMatchingRange(Predicate<IDRangeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ranges.size(); ++i) {
            if (!predicate.test(this.ranges.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ranges. No match found.");
        }
        return this.setNewRangeLike(index, this.buildRange(index));
    }

    @Override
    public String getRule() {
        return this.rule;
    }

    @Override
    public A withRule(String rule) {
        this.rule = rule;
        return (A)this;
    }

    @Override
    public Boolean hasRule() {
        return this.rule != null;
    }

    @Override
    public A withNewRule(String arg1) {
        return this.withRule(new String(arg1));
    }

    @Override
    public A withNewRule(StringBuilder arg1) {
        return this.withRule(new String(arg1));
    }

    @Override
    public A withNewRule(StringBuffer arg1) {
        return this.withRule(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunAsUserStrategyOptionsFluentImpl that = (RunAsUserStrategyOptionsFluentImpl)o;
        if (this.ranges != null ? !this.ranges.equals(that.ranges) : that.ranges != null) {
            return false;
        }
        return !(this.rule != null ? !this.rule.equals(that.rule) : that.rule != null);
    }

    public int hashCode() {
        return Objects.hash(this.ranges, this.rule, super.hashCode());
    }

    public class RangesNestedImpl<N>
    extends IDRangeFluentImpl<RunAsUserStrategyOptionsFluent.RangesNested<N>>
    implements RunAsUserStrategyOptionsFluent.RangesNested<N>,
    Nested<N> {
        private final IDRangeBuilder builder;
        private final int index;

        RangesNestedImpl(int index, IDRange item) {
            this.index = index;
            this.builder = new IDRangeBuilder(this, item);
        }

        RangesNestedImpl() {
            this.index = -1;
            this.builder = new IDRangeBuilder(this);
        }

        @Override
        public N and() {
            return (N)RunAsUserStrategyOptionsFluentImpl.this.setToRanges(this.index, this.builder.build());
        }

        @Override
        public N endRange() {
            return this.and();
        }
    }
}

