package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class PodMetricsFluentImpl<A extends io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent<A>{
  public PodMetricsFluentImpl() {
  }
  public PodMetricsFluentImpl(io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetrics instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withContainers(instance.getContainers()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withTimestamp(instance.getTimestamp()); 
    this.withWindow(instance.getWindow()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.String apiVersion;
  private java.util.List<io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder> containers =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder>();
  private java.lang.String kind;
  private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
  private java.lang.String timestamp;
  private io.fabric8.kubernetes.api.model.Duration window;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public java.lang.Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * Method is deprecated. use withApiVersion instead.
   */
  @java.lang.Deprecated
  public A withNewApiVersion(java.lang.String arg0) {
    return (A)withApiVersion(new String(arg0));
  }
  public A addToContainers(java.lang.Integer index,io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics item) {
    if (this.containers == null) {this.containers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder>();}
    io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder builder = new io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder(item);_visitables.get("containers").add(index >= 0 ? index : _visitables.get("containers").size(), builder);this.containers.add(index >= 0 ? index : containers.size(), builder); return (A)this;
  }
  public A setToContainers(java.lang.Integer index,io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics item) {
    if (this.containers == null) {this.containers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder>();}
    io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder builder = new io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder(item);
    if (index < 0 || index >= _visitables.get("containers").size()) { _visitables.get("containers").add(builder); } else { _visitables.get("containers").set(index, builder);}
    if (index < 0 || index >= containers.size()) { containers.add(builder); } else { containers.set(index, builder);}
     return (A)this;
  }
  public A addToContainers(io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics... items) {
    if (this.containers == null) {this.containers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder>();}
    for (io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics item : items) {io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder builder = new io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
  }
  public A addAllToContainers(java.util.Collection<io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics> items) {
    if (this.containers == null) {this.containers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder>();}
    for (io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics item : items) {io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder builder = new io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
  }
  public A removeFromContainers(io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics... items) {
    for (io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics item : items) {io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder builder = new io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
  }
  public A removeAllFromContainers(java.util.Collection<io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics> items) {
    for (io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics item : items) {io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder builder = new io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromContainers(java.util.function.Predicate<io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder> predicate) {
    if (containers == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder> each = containers.iterator();
    final List visitables = _visitables.get("containers");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildContainers instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics> getContainers() {
    return build(containers);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics> buildContainers() {
    return build(containers);
  }
  public io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics buildContainer(java.lang.Integer index) {
    return this.containers.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics buildFirstContainer() {
    return this.containers.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics buildLastContainer() {
    return this.containers.get(containers.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics buildMatchingContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder item: containers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder item: containers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContainers(java.util.List<io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics> containers) {
    if (this.containers != null) { _visitables.get("containers").removeAll(this.containers);}
    if (containers != null) {this.containers = new java.util.ArrayList<io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder>(); for (io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics item : containers){this.addToContainers(item);}} else { this.containers = null;} return (A) this;
  }
  public A withContainers(io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics... containers) {
    if (this.containers != null) {this.containers.clear();}
    if (containers != null) {for (io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics item :containers){ this.addToContainers(item);}} return (A) this;
  }
  public java.lang.Boolean hasContainers() {
    return containers != null && !containers.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent.ContainersNested<A> addNewContainer() {
    return new io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluentImpl.ContainersNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent.ContainersNested<A> addNewContainerLike(io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics item) {
    return new io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluentImpl.ContainersNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent.ContainersNested<A> setNewContainerLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics item) {
    return new io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluentImpl.ContainersNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent.ContainersNested<A> editContainer(java.lang.Integer index) {
    if (containers.size() <= index) throw new RuntimeException("Can't edit containers. Index exceeds size.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent.ContainersNested<A> editFirstContainer() {
    if (containers.size() == 0) throw new RuntimeException("Can't edit first containers. The list is empty.");
    return setNewContainerLike(0, buildContainer(0));
  }
  public io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent.ContainersNested<A> editLastContainer() {
    int index = containers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last containers. The list is empty.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent.ContainersNested<A> editMatchingContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<containers.size();i++) { 
    if (predicate.test(containers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching containers. No match found.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * Method is deprecated. use withKind instead.
   */
  @java.lang.Deprecated
  public A withNewKind(java.lang.String arg0) {
    return (A)withKind(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent.MetadataNested<A> withNewMetadata() {
    return new io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public java.lang.String getTimestamp() {
    return this.timestamp;
  }
  public A withTimestamp(java.lang.String timestamp) {
    this.timestamp=timestamp; return (A) this;
  }
  public java.lang.Boolean hasTimestamp() {
    return this.timestamp != null;
  }
  
  /**
   * Method is deprecated. use withTimestamp instead.
   */
  @java.lang.Deprecated
  public A withNewTimestamp(java.lang.String arg0) {
    return (A)withTimestamp(new String(arg0));
  }
  public io.fabric8.kubernetes.api.model.Duration getWindow() {
    return this.window;
  }
  public A withWindow(io.fabric8.kubernetes.api.model.Duration window) {
    this.window=window; return (A) this;
  }
  public java.lang.Boolean hasWindow() {
    return this.window != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PodMetricsFluentImpl that = (PodMetricsFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (containers != null ? !containers.equals(that.containers) :that.containers != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (timestamp != null ? !timestamp.equals(that.timestamp) :that.timestamp != null) return false;
    if (window != null ? !window.equals(that.window) :that.window != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  containers,  kind,  metadata,  timestamp,  window,  additionalProperties,  super.hashCode());
  }
  public class ContainersNestedImpl<N> extends io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsFluentImpl<io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent.ContainersNested<N>> implements io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent.ContainersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ContainersNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder(this, item);
    }
    ContainersNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) PodMetricsFluentImpl.this.setToContainers(index,builder.build());
    }
    public N endContainer() {
      return and();
    }
    
  }
  public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent.MetadataNested<N>> implements io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) PodMetricsFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}