package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class VarBuilder extends VarFluent<VarBuilder> implements VisitableBuilder<Var,VarBuilder>{
  public VarBuilder() {
    this(new Var());
  }
  
  public VarBuilder(VarFluent<?> fluent) {
    this(fluent, new Var());
  }
  
  public VarBuilder(VarFluent<?> fluent,Var instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public VarBuilder(Var instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  VarFluent<?> fluent;
  
  public Var build() {
    Var buildable = new Var(fluent.buildFieldref(),fluent.getName(),fluent.buildObjref());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}