package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SourceSelectorFluent<A extends SourceSelectorFluent<A>> extends BaseFluent<A>{
  public SourceSelectorFluent() {
  }
  
  public SourceSelectorFluent(SourceSelector instance) {
    this.copyInstance(instance);
  }
  private String fieldPath;
  private String group;
  private String kind;
  private String name;
  private String namespace;
  private FieldOptionsBuilder options;
  private String version;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SourceSelector instance) {
    instance = (instance != null ? instance : new SourceSelector());
    if (instance != null) {
          this.withFieldPath(instance.getFieldPath());
          this.withGroup(instance.getGroup());
          this.withKind(instance.getKind());
          this.withName(instance.getName());
          this.withNamespace(instance.getNamespace());
          this.withOptions(instance.getOptions());
          this.withVersion(instance.getVersion());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getFieldPath() {
    return this.fieldPath;
  }
  
  public A withFieldPath(String fieldPath) {
    this.fieldPath = fieldPath;
    return (A) this;
  }
  
  public boolean hasFieldPath() {
    return this.fieldPath != null;
  }
  
  public String getGroup() {
    return this.group;
  }
  
  public A withGroup(String group) {
    this.group = group;
    return (A) this;
  }
  
  public boolean hasGroup() {
    return this.group != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getNamespace() {
    return this.namespace;
  }
  
  public A withNamespace(String namespace) {
    this.namespace = namespace;
    return (A) this;
  }
  
  public boolean hasNamespace() {
    return this.namespace != null;
  }
  
  public FieldOptions buildOptions() {
    return this.options != null ? this.options.build() : null;
  }
  
  public A withOptions(FieldOptions options) {
    this._visitables.remove("options");
    if (options != null) {
        this.options = new FieldOptionsBuilder(options);
        this._visitables.get("options").add(this.options);
    } else {
        this.options = null;
        this._visitables.get("options").remove(this.options);
    }
    return (A) this;
  }
  
  public boolean hasOptions() {
    return this.options != null;
  }
  
  public A withNewOptions(Boolean create,String delimiter,String encoding,Integer index) {
    return (A)withOptions(new FieldOptions(create, delimiter, encoding, index));
  }
  
  public OptionsNested<A> withNewOptions() {
    return new OptionsNested(null);
  }
  
  public OptionsNested<A> withNewOptionsLike(FieldOptions item) {
    return new OptionsNested(item);
  }
  
  public OptionsNested<A> editOptions() {
    return withNewOptionsLike(java.util.Optional.ofNullable(buildOptions()).orElse(null));
  }
  
  public OptionsNested<A> editOrNewOptions() {
    return withNewOptionsLike(java.util.Optional.ofNullable(buildOptions()).orElse(new FieldOptionsBuilder().build()));
  }
  
  public OptionsNested<A> editOrNewOptionsLike(FieldOptions item) {
    return withNewOptionsLike(java.util.Optional.ofNullable(buildOptions()).orElse(item));
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SourceSelectorFluent that = (SourceSelectorFluent) o;
    if (!java.util.Objects.equals(fieldPath, that.fieldPath)) return false;
    if (!java.util.Objects.equals(group, that.group)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(namespace, that.namespace)) return false;
    if (!java.util.Objects.equals(options, that.options)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(fieldPath,  group,  kind,  name,  namespace,  options,  version,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (fieldPath != null) { sb.append("fieldPath:"); sb.append(fieldPath + ","); }
    if (group != null) { sb.append("group:"); sb.append(group + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (options != null) { sb.append("options:"); sb.append(options + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class OptionsNested<N> extends FieldOptionsFluent<OptionsNested<N>> implements Nested<N>{
    OptionsNested(FieldOptions item) {
      this.builder = new FieldOptionsBuilder(this, item);
    }
    FieldOptionsBuilder builder;
    
    public N and() {
      return (N) SourceSelectorFluent.this.withOptions(builder.build());
    }
    
    public N endOptions() {
      return and();
    }
    
  
  }

}