package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SelectorBuilder extends SelectorFluent<SelectorBuilder> implements VisitableBuilder<Selector,SelectorBuilder>{
  public SelectorBuilder() {
    this(new Selector());
  }
  
  public SelectorBuilder(SelectorFluent<?> fluent) {
    this(fluent, new Selector());
  }
  
  public SelectorBuilder(SelectorFluent<?> fluent,Selector instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SelectorBuilder(Selector instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SelectorFluent<?> fluent;
  
  public Selector build() {
    Selector buildable = new Selector(fluent.getAnnotationSelector(),fluent.getGroup(),fluent.getKind(),fluent.getLabelSelector(),fluent.getName(),fluent.getNamespace(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}