/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.Patch;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.Selector;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.SelectorBuilder;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.SelectorFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PatchFluent<A extends PatchFluent<A>>
extends BaseFluent<A> {
    private Map<String, Boolean> options;
    private String patch;
    private String path;
    private SelectorBuilder target;
    private Map<String, Object> additionalProperties;

    public PatchFluent() {
    }

    public PatchFluent(Patch instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Patch instance) {
        Patch patch = instance = instance != null ? instance : new Patch();
        if (instance != null) {
            this.withOptions(instance.getOptions());
            this.withPatch(instance.getPatch());
            this.withPath(instance.getPath());
            this.withTarget(instance.getTarget());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToOptions(String key, Boolean value) {
        if (this.options == null && key != null && value != null) {
            this.options = new LinkedHashMap<String, Boolean>();
        }
        if (key != null && value != null) {
            this.options.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToOptions(Map<String, Boolean> map) {
        if (this.options == null && map != null) {
            this.options = new LinkedHashMap<String, Boolean>();
        }
        if (map != null) {
            this.options.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromOptions(String key) {
        if (this.options == null) {
            return (A)((Object)this);
        }
        if (key != null && this.options != null) {
            this.options.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromOptions(Map<String, Boolean> map) {
        if (this.options == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.options == null) continue;
                this.options.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Boolean> getOptions() {
        return this.options;
    }

    public <K, V> A withOptions(Map<String, Boolean> options) {
        this.options = options == null ? null : new LinkedHashMap<String, Boolean>(options);
        return (A)((Object)this);
    }

    public boolean hasOptions() {
        return this.options != null;
    }

    public String getPatch() {
        return this.patch;
    }

    public A withPatch(String patch) {
        this.patch = patch;
        return (A)((Object)this);
    }

    public boolean hasPatch() {
        return this.patch != null;
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public Selector buildTarget() {
        return this.target != null ? this.target.build() : null;
    }

    public A withTarget(Selector target) {
        this._visitables.remove((Object)"target");
        if (target != null) {
            this.target = new SelectorBuilder(target);
            this._visitables.get((Object)"target").add(this.target);
        } else {
            this.target = null;
            this._visitables.get((Object)"target").remove((Object)this.target);
        }
        return (A)((Object)this);
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public TargetNested<A> withNewTarget() {
        return new TargetNested(null);
    }

    public TargetNested<A> withNewTargetLike(Selector item) {
        return new TargetNested(item);
    }

    public TargetNested<A> editTarget() {
        return this.withNewTargetLike(Optional.ofNullable(this.buildTarget()).orElse(null));
    }

    public TargetNested<A> editOrNewTarget() {
        return this.withNewTargetLike(Optional.ofNullable(this.buildTarget()).orElse(new SelectorBuilder().build()));
    }

    public TargetNested<A> editOrNewTargetLike(Selector item) {
        return this.withNewTargetLike(Optional.ofNullable(this.buildTarget()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PatchFluent that = (PatchFluent)((Object)o);
        if (!Objects.equals(this.options, that.options)) {
            return false;
        }
        if (!Objects.equals(this.patch, that.patch)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals((Object)this.target, (Object)that.target)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.options, this.patch, this.path, this.target, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.options != null && !this.options.isEmpty()) {
            sb.append("options:");
            sb.append(this.options + ",");
        }
        if (this.patch != null) {
            sb.append("patch:");
            sb.append(this.patch + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.target != null) {
            sb.append("target:");
            sb.append(this.target + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TargetNested<N>
    extends SelectorFluent<TargetNested<N>>
    implements Nested<N> {
        SelectorBuilder builder;

        TargetNested(Selector item) {
            this.builder = new SelectorBuilder(this, item);
        }

        public N and() {
            return (N)PatchFluent.this.withTarget(this.builder.build());
        }

        public N endTarget() {
            return this.and();
        }
    }
}

