/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.FieldOptions;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.FieldOptionsBuilder;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.FieldOptionsFluent;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.Selector;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.SelectorBuilder;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.SelectorFluent;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.TargetSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class TargetSelectorFluent<A extends TargetSelectorFluent<A>>
extends BaseFluent<A> {
    private List<String> fieldPaths = new ArrayList<String>();
    private FieldOptionsBuilder options;
    private ArrayList<SelectorBuilder> reject = new ArrayList();
    private SelectorBuilder select;
    private Map<String, Object> additionalProperties;

    public TargetSelectorFluent() {
    }

    public TargetSelectorFluent(TargetSelector instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(TargetSelector instance) {
        TargetSelector targetSelector = instance = instance != null ? instance : new TargetSelector();
        if (instance != null) {
            this.withFieldPaths(instance.getFieldPaths());
            this.withOptions(instance.getOptions());
            this.withReject(instance.getReject());
            this.withSelect(instance.getSelect());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToFieldPaths(int index, String item) {
        if (this.fieldPaths == null) {
            this.fieldPaths = new ArrayList<String>();
        }
        this.fieldPaths.add(index, item);
        return (A)((Object)this);
    }

    public A setToFieldPaths(int index, String item) {
        if (this.fieldPaths == null) {
            this.fieldPaths = new ArrayList<String>();
        }
        this.fieldPaths.set(index, item);
        return (A)((Object)this);
    }

    public A addToFieldPaths(String ... items) {
        if (this.fieldPaths == null) {
            this.fieldPaths = new ArrayList<String>();
        }
        for (String item : items) {
            this.fieldPaths.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToFieldPaths(Collection<String> items) {
        if (this.fieldPaths == null) {
            this.fieldPaths = new ArrayList<String>();
        }
        for (String item : items) {
            this.fieldPaths.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromFieldPaths(String ... items) {
        if (this.fieldPaths == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.fieldPaths.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromFieldPaths(Collection<String> items) {
        if (this.fieldPaths == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.fieldPaths.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getFieldPaths() {
        return this.fieldPaths;
    }

    public String getFieldPath(int index) {
        return this.fieldPaths.get(index);
    }

    public String getFirstFieldPath() {
        return this.fieldPaths.get(0);
    }

    public String getLastFieldPath() {
        return this.fieldPaths.get(this.fieldPaths.size() - 1);
    }

    public String getMatchingFieldPath(Predicate<String> predicate) {
        for (String item : this.fieldPaths) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingFieldPath(Predicate<String> predicate) {
        for (String item : this.fieldPaths) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFieldPaths(List<String> fieldPaths) {
        if (fieldPaths != null) {
            this.fieldPaths = new ArrayList<String>();
            for (String item : fieldPaths) {
                this.addToFieldPaths(item);
            }
        } else {
            this.fieldPaths = null;
        }
        return (A)((Object)this);
    }

    public A withFieldPaths(String ... fieldPaths) {
        if (this.fieldPaths != null) {
            this.fieldPaths.clear();
            this._visitables.remove((Object)"fieldPaths");
        }
        if (fieldPaths != null) {
            for (String item : fieldPaths) {
                this.addToFieldPaths(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasFieldPaths() {
        return this.fieldPaths != null && !this.fieldPaths.isEmpty();
    }

    public FieldOptions buildOptions() {
        return this.options != null ? this.options.build() : null;
    }

    public A withOptions(FieldOptions options) {
        this._visitables.remove((Object)"options");
        if (options != null) {
            this.options = new FieldOptionsBuilder(options);
            this._visitables.get((Object)"options").add(this.options);
        } else {
            this.options = null;
            this._visitables.get((Object)"options").remove((Object)this.options);
        }
        return (A)((Object)this);
    }

    public boolean hasOptions() {
        return this.options != null;
    }

    public A withNewOptions(Boolean create, String delimiter, String encoding, Integer index) {
        return this.withOptions(new FieldOptions(create, delimiter, encoding, index));
    }

    public OptionsNested<A> withNewOptions() {
        return new OptionsNested(null);
    }

    public OptionsNested<A> withNewOptionsLike(FieldOptions item) {
        return new OptionsNested(item);
    }

    public OptionsNested<A> editOptions() {
        return this.withNewOptionsLike(Optional.ofNullable(this.buildOptions()).orElse(null));
    }

    public OptionsNested<A> editOrNewOptions() {
        return this.withNewOptionsLike(Optional.ofNullable(this.buildOptions()).orElse(new FieldOptionsBuilder().build()));
    }

    public OptionsNested<A> editOrNewOptionsLike(FieldOptions item) {
        return this.withNewOptionsLike(Optional.ofNullable(this.buildOptions()).orElse(item));
    }

    public A addToReject(int index, Selector item) {
        if (this.reject == null) {
            this.reject = new ArrayList();
        }
        SelectorBuilder builder = new SelectorBuilder(item);
        if (index < 0 || index >= this.reject.size()) {
            this._visitables.get((Object)"reject").add(builder);
            this.reject.add(builder);
        } else {
            this._visitables.get((Object)"reject").add(index, builder);
            this.reject.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToReject(int index, Selector item) {
        if (this.reject == null) {
            this.reject = new ArrayList();
        }
        SelectorBuilder builder = new SelectorBuilder(item);
        if (index < 0 || index >= this.reject.size()) {
            this._visitables.get((Object)"reject").add(builder);
            this.reject.add(builder);
        } else {
            this._visitables.get((Object)"reject").set(index, builder);
            this.reject.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToReject(Selector ... items) {
        if (this.reject == null) {
            this.reject = new ArrayList();
        }
        for (Selector item : items) {
            SelectorBuilder builder = new SelectorBuilder(item);
            this._visitables.get((Object)"reject").add(builder);
            this.reject.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToReject(Collection<Selector> items) {
        if (this.reject == null) {
            this.reject = new ArrayList();
        }
        for (Selector item : items) {
            SelectorBuilder builder = new SelectorBuilder(item);
            this._visitables.get((Object)"reject").add(builder);
            this.reject.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromReject(Selector ... items) {
        if (this.reject == null) {
            return (A)((Object)this);
        }
        for (Selector item : items) {
            SelectorBuilder builder = new SelectorBuilder(item);
            this._visitables.get((Object)"reject").remove((Object)builder);
            this.reject.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromReject(Collection<Selector> items) {
        if (this.reject == null) {
            return (A)((Object)this);
        }
        for (Selector item : items) {
            SelectorBuilder builder = new SelectorBuilder(item);
            this._visitables.get((Object)"reject").remove((Object)builder);
            this.reject.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromReject(Predicate<SelectorBuilder> predicate) {
        if (this.reject == null) {
            return (A)((Object)this);
        }
        Iterator<SelectorBuilder> each = this.reject.iterator();
        List visitables = this._visitables.get((Object)"reject");
        while (each.hasNext()) {
            SelectorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Selector> buildReject() {
        return this.reject != null ? TargetSelectorFluent.build(this.reject) : null;
    }

    public Selector buildReject(int index) {
        return this.reject.get(index).build();
    }

    public Selector buildFirstReject() {
        return this.reject.get(0).build();
    }

    public Selector buildLastReject() {
        return this.reject.get(this.reject.size() - 1).build();
    }

    public Selector buildMatchingReject(Predicate<SelectorBuilder> predicate) {
        for (SelectorBuilder item : this.reject) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingReject(Predicate<SelectorBuilder> predicate) {
        for (SelectorBuilder item : this.reject) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withReject(List<Selector> reject) {
        if (this.reject != null) {
            this._visitables.get((Object)"reject").clear();
        }
        if (reject != null) {
            this.reject = new ArrayList();
            for (Selector item : reject) {
                this.addToReject(item);
            }
        } else {
            this.reject = null;
        }
        return (A)((Object)this);
    }

    public A withReject(Selector ... reject) {
        if (this.reject != null) {
            this.reject.clear();
            this._visitables.remove((Object)"reject");
        }
        if (reject != null) {
            for (Selector item : reject) {
                this.addToReject(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasReject() {
        return this.reject != null && !this.reject.isEmpty();
    }

    public RejectNested<A> addNewReject() {
        return new RejectNested(-1, null);
    }

    public RejectNested<A> addNewRejectLike(Selector item) {
        return new RejectNested(-1, item);
    }

    public RejectNested<A> setNewRejectLike(int index, Selector item) {
        return new RejectNested(index, item);
    }

    public RejectNested<A> editReject(int index) {
        if (this.reject.size() <= index) {
            throw new RuntimeException("Can't edit reject. Index exceeds size.");
        }
        return this.setNewRejectLike(index, this.buildReject(index));
    }

    public RejectNested<A> editFirstReject() {
        if (this.reject.size() == 0) {
            throw new RuntimeException("Can't edit first reject. The list is empty.");
        }
        return this.setNewRejectLike(0, this.buildReject(0));
    }

    public RejectNested<A> editLastReject() {
        int index = this.reject.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last reject. The list is empty.");
        }
        return this.setNewRejectLike(index, this.buildReject(index));
    }

    public RejectNested<A> editMatchingReject(Predicate<SelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.reject.size(); ++i) {
            if (!predicate.test(this.reject.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching reject. No match found.");
        }
        return this.setNewRejectLike(index, this.buildReject(index));
    }

    public Selector buildSelect() {
        return this.select != null ? this.select.build() : null;
    }

    public A withSelect(Selector select) {
        this._visitables.remove((Object)"select");
        if (select != null) {
            this.select = new SelectorBuilder(select);
            this._visitables.get((Object)"select").add(this.select);
        } else {
            this.select = null;
            this._visitables.get((Object)"select").remove((Object)this.select);
        }
        return (A)((Object)this);
    }

    public boolean hasSelect() {
        return this.select != null;
    }

    public SelectNested<A> withNewSelect() {
        return new SelectNested(null);
    }

    public SelectNested<A> withNewSelectLike(Selector item) {
        return new SelectNested(item);
    }

    public SelectNested<A> editSelect() {
        return this.withNewSelectLike(Optional.ofNullable(this.buildSelect()).orElse(null));
    }

    public SelectNested<A> editOrNewSelect() {
        return this.withNewSelectLike(Optional.ofNullable(this.buildSelect()).orElse(new SelectorBuilder().build()));
    }

    public SelectNested<A> editOrNewSelectLike(Selector item) {
        return this.withNewSelectLike(Optional.ofNullable(this.buildSelect()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TargetSelectorFluent that = (TargetSelectorFluent)((Object)o);
        if (!Objects.equals(this.fieldPaths, that.fieldPaths)) {
            return false;
        }
        if (!Objects.equals((Object)this.options, (Object)that.options)) {
            return false;
        }
        if (!Objects.equals(this.reject, that.reject)) {
            return false;
        }
        if (!Objects.equals((Object)this.select, (Object)that.select)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldPaths, this.options, this.reject, this.select, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fieldPaths != null && !this.fieldPaths.isEmpty()) {
            sb.append("fieldPaths:");
            sb.append(this.fieldPaths + ",");
        }
        if (this.options != null) {
            sb.append("options:");
            sb.append((Object)((Object)this.options) + ",");
        }
        if (this.reject != null && !this.reject.isEmpty()) {
            sb.append("reject:");
            sb.append(this.reject + ",");
        }
        if (this.select != null) {
            sb.append("select:");
            sb.append((Object)((Object)this.select) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SelectNested<N>
    extends SelectorFluent<SelectNested<N>>
    implements Nested<N> {
        SelectorBuilder builder;

        SelectNested(Selector item) {
            this.builder = new SelectorBuilder(this, item);
        }

        public N and() {
            return (N)TargetSelectorFluent.this.withSelect(this.builder.build());
        }

        public N endSelect() {
            return this.and();
        }
    }

    public class RejectNested<N>
    extends SelectorFluent<RejectNested<N>>
    implements Nested<N> {
        SelectorBuilder builder;
        int index;

        RejectNested(int index, Selector item) {
            this.index = index;
            this.builder = new SelectorBuilder(this, item);
        }

        public N and() {
            return (N)TargetSelectorFluent.this.setToReject(this.index, this.builder.build());
        }

        public N endReject() {
            return this.and();
        }
    }

    public class OptionsNested<N>
    extends FieldOptionsFluent<OptionsNested<N>>
    implements Nested<N> {
        FieldOptionsBuilder builder;

        OptionsNested(FieldOptions item) {
            this.builder = new FieldOptionsBuilder(this, item);
        }

        public N and() {
            return (N)TargetSelectorFluent.this.withOptions(this.builder.build());
        }

        public N endOptions() {
            return this.and();
        }
    }
}

