/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.kustomize.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.Patch;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.PatchFluent;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.Selector;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.SelectorBuilder;
import io.fabric8.kubernetes.api.model.kustomize.v1beta1.SelectorFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class PatchFluentImpl<A extends PatchFluent<A>>
extends BaseFluent<A>
implements PatchFluent<A> {
    private Map<String, Boolean> options;
    private String patch;
    private String path;
    private SelectorBuilder target;
    private Map<String, Object> additionalProperties;

    public PatchFluentImpl() {
    }

    public PatchFluentImpl(Patch instance) {
        if (instance != null) {
            this.withOptions(instance.getOptions());
            this.withPatch(instance.getPatch());
            this.withPath(instance.getPath());
            this.withTarget(instance.getTarget());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToOptions(String key, Boolean value) {
        if (this.options == null && key != null && value != null) {
            this.options = new LinkedHashMap<String, Boolean>();
        }
        if (key != null && value != null) {
            this.options.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToOptions(Map<String, Boolean> map) {
        if (this.options == null && map != null) {
            this.options = new LinkedHashMap<String, Boolean>();
        }
        if (map != null) {
            this.options.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromOptions(String key) {
        if (this.options == null) {
            return (A)this;
        }
        if (key != null && this.options != null) {
            this.options.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromOptions(Map<String, Boolean> map) {
        if (this.options == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.options == null) continue;
                this.options.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Boolean> getOptions() {
        return this.options;
    }

    @Override
    public <K, V> A withOptions(Map<String, Boolean> options) {
        this.options = options == null ? null : new LinkedHashMap<String, Boolean>(options);
        return (A)this;
    }

    @Override
    public Boolean hasOptions() {
        return this.options != null;
    }

    @Override
    public String getPatch() {
        return this.patch;
    }

    @Override
    public A withPatch(String patch) {
        this.patch = patch;
        return (A)this;
    }

    @Override
    public Boolean hasPatch() {
        return this.patch != null;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    @Override
    public Boolean hasPath() {
        return this.path != null;
    }

    @Override
    @Deprecated
    public Selector getTarget() {
        return this.target != null ? this.target.build() : null;
    }

    @Override
    public Selector buildTarget() {
        return this.target != null ? this.target.build() : null;
    }

    @Override
    public A withTarget(Selector target) {
        this._visitables.get((Object)"target").remove(this.target);
        if (target != null) {
            this.target = new SelectorBuilder(target);
            this._visitables.get((Object)"target").add(this.target);
        } else {
            this.target = null;
            this._visitables.get((Object)"target").remove(this.target);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTarget() {
        return this.target != null;
    }

    @Override
    public PatchFluent.TargetNested<A> withNewTarget() {
        return new TargetNestedImpl();
    }

    @Override
    public PatchFluent.TargetNested<A> withNewTargetLike(Selector item) {
        return new TargetNestedImpl(item);
    }

    @Override
    public PatchFluent.TargetNested<A> editTarget() {
        return this.withNewTargetLike(this.getTarget());
    }

    @Override
    public PatchFluent.TargetNested<A> editOrNewTarget() {
        return this.withNewTargetLike(this.getTarget() != null ? this.getTarget() : new SelectorBuilder().build());
    }

    @Override
    public PatchFluent.TargetNested<A> editOrNewTargetLike(Selector item) {
        return this.withNewTargetLike(this.getTarget() != null ? this.getTarget() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PatchFluentImpl that = (PatchFluentImpl)o;
        if (!Objects.equals(this.options, that.options)) {
            return false;
        }
        if (!Objects.equals(this.patch, that.patch)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.target, that.target)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.options, this.patch, this.path, this.target, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.options != null && !this.options.isEmpty()) {
            sb.append("options:");
            sb.append(this.options + ",");
        }
        if (this.patch != null) {
            sb.append("patch:");
            sb.append(this.patch + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.target != null) {
            sb.append("target:");
            sb.append(this.target + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class TargetNestedImpl<N>
    extends SelectorFluentImpl<PatchFluent.TargetNested<N>>
    implements PatchFluent.TargetNested<N>,
    Nested<N> {
        SelectorBuilder builder;

        TargetNestedImpl(Selector item) {
            this.builder = new SelectorBuilder(this, item);
        }

        TargetNestedImpl() {
            this.builder = new SelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)PatchFluentImpl.this.withTarget(this.builder.build());
        }

        @Override
        public N endTarget() {
            return this.and();
        }
    }
}

