/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPBackendRef;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPBackendRefBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPBackendRefFluentImpl;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPRouteFilter;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPRouteFilterBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPRouteFilterFluentImpl;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPRouteMatch;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPRouteMatchBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPRouteMatchFluentImpl;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPRouteRule;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPRouteRuleFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HTTPRouteRuleFluentImpl<A extends HTTPRouteRuleFluent<A>>
extends BaseFluent<A>
implements HTTPRouteRuleFluent<A> {
    private ArrayList<HTTPBackendRefBuilder> backendRefs = new ArrayList();
    private ArrayList<HTTPRouteFilterBuilder> filters = new ArrayList();
    private ArrayList<HTTPRouteMatchBuilder> matches = new ArrayList();
    private Map<String, Object> additionalProperties;

    public HTTPRouteRuleFluentImpl() {
    }

    public HTTPRouteRuleFluentImpl(HTTPRouteRule instance) {
        if (instance != null) {
            this.withBackendRefs(instance.getBackendRefs());
            this.withFilters(instance.getFilters());
            this.withMatches(instance.getMatches());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToBackendRefs(int index, HTTPBackendRef item) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);
        if (index < 0 || index >= this.backendRefs.size()) {
            this._visitables.get((Object)"backendRefs").add(builder);
            this.backendRefs.add(builder);
        } else {
            this._visitables.get((Object)"backendRefs").add(index, builder);
            this.backendRefs.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToBackendRefs(int index, HTTPBackendRef item) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);
        if (index < 0 || index >= this.backendRefs.size()) {
            this._visitables.get((Object)"backendRefs").add(builder);
            this.backendRefs.add(builder);
        } else {
            this._visitables.get((Object)"backendRefs").set(index, builder);
            this.backendRefs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToBackendRefs(HTTPBackendRef ... items) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        for (HTTPBackendRef item : items) {
            HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);
            this._visitables.get((Object)"backendRefs").add(builder);
            this.backendRefs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToBackendRefs(Collection<HTTPBackendRef> items) {
        if (this.backendRefs == null) {
            this.backendRefs = new ArrayList();
        }
        for (HTTPBackendRef item : items) {
            HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);
            this._visitables.get((Object)"backendRefs").add(builder);
            this.backendRefs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromBackendRefs(HTTPBackendRef ... items) {
        for (HTTPBackendRef item : items) {
            HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);
            this._visitables.get((Object)"backendRefs").remove(builder);
            if (this.backendRefs == null) continue;
            this.backendRefs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromBackendRefs(Collection<HTTPBackendRef> items) {
        for (HTTPBackendRef item : items) {
            HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);
            this._visitables.get((Object)"backendRefs").remove(builder);
            if (this.backendRefs == null) continue;
            this.backendRefs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromBackendRefs(Predicate<HTTPBackendRefBuilder> predicate) {
        if (this.backendRefs == null) {
            return (A)this;
        }
        Iterator<HTTPBackendRefBuilder> each = this.backendRefs.iterator();
        List visitables = this._visitables.get((Object)"backendRefs");
        while (each.hasNext()) {
            HTTPBackendRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HTTPBackendRef> getBackendRefs() {
        return this.backendRefs != null ? HTTPRouteRuleFluentImpl.build(this.backendRefs) : null;
    }

    @Override
    public List<HTTPBackendRef> buildBackendRefs() {
        return this.backendRefs != null ? HTTPRouteRuleFluentImpl.build(this.backendRefs) : null;
    }

    @Override
    public HTTPBackendRef buildBackendRef(int index) {
        return this.backendRefs.get(index).build();
    }

    @Override
    public HTTPBackendRef buildFirstBackendRef() {
        return this.backendRefs.get(0).build();
    }

    @Override
    public HTTPBackendRef buildLastBackendRef() {
        return this.backendRefs.get(this.backendRefs.size() - 1).build();
    }

    @Override
    public HTTPBackendRef buildMatchingBackendRef(Predicate<HTTPBackendRefBuilder> predicate) {
        for (HTTPBackendRefBuilder item : this.backendRefs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingBackendRef(Predicate<HTTPBackendRefBuilder> predicate) {
        for (HTTPBackendRefBuilder item : this.backendRefs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withBackendRefs(List<HTTPBackendRef> backendRefs) {
        if (this.backendRefs != null) {
            this._visitables.get((Object)"backendRefs").clear();
        }
        if (backendRefs != null) {
            this.backendRefs = new ArrayList();
            for (HTTPBackendRef item : backendRefs) {
                this.addToBackendRefs(item);
            }
        } else {
            this.backendRefs = null;
        }
        return (A)this;
    }

    @Override
    public A withBackendRefs(HTTPBackendRef ... backendRefs) {
        if (this.backendRefs != null) {
            this.backendRefs.clear();
            this._visitables.remove((Object)"backendRefs");
        }
        if (backendRefs != null) {
            for (HTTPBackendRef item : backendRefs) {
                this.addToBackendRefs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasBackendRefs() {
        return this.backendRefs != null && !this.backendRefs.isEmpty();
    }

    @Override
    public HTTPRouteRuleFluent.BackendRefsNested<A> addNewBackendRef() {
        return new BackendRefsNestedImpl();
    }

    @Override
    public HTTPRouteRuleFluent.BackendRefsNested<A> addNewBackendRefLike(HTTPBackendRef item) {
        return new BackendRefsNestedImpl(-1, item);
    }

    @Override
    public HTTPRouteRuleFluent.BackendRefsNested<A> setNewBackendRefLike(int index, HTTPBackendRef item) {
        return new BackendRefsNestedImpl(index, item);
    }

    @Override
    public HTTPRouteRuleFluent.BackendRefsNested<A> editBackendRef(int index) {
        if (this.backendRefs.size() <= index) {
            throw new RuntimeException("Can't edit backendRefs. Index exceeds size.");
        }
        return this.setNewBackendRefLike(index, this.buildBackendRef(index));
    }

    @Override
    public HTTPRouteRuleFluent.BackendRefsNested<A> editFirstBackendRef() {
        if (this.backendRefs.size() == 0) {
            throw new RuntimeException("Can't edit first backendRefs. The list is empty.");
        }
        return this.setNewBackendRefLike(0, this.buildBackendRef(0));
    }

    @Override
    public HTTPRouteRuleFluent.BackendRefsNested<A> editLastBackendRef() {
        int index = this.backendRefs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last backendRefs. The list is empty.");
        }
        return this.setNewBackendRefLike(index, this.buildBackendRef(index));
    }

    @Override
    public HTTPRouteRuleFluent.BackendRefsNested<A> editMatchingBackendRef(Predicate<HTTPBackendRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.backendRefs.size(); ++i) {
            if (!predicate.test(this.backendRefs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching backendRefs. No match found.");
        }
        return this.setNewBackendRefLike(index, this.buildBackendRef(index));
    }

    @Override
    public A addToFilters(int index, HTTPRouteFilter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get((Object)"filters").add(index, builder);
            this.filters.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToFilters(int index, HTTPRouteFilter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get((Object)"filters").set(index, builder);
            this.filters.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToFilters(HTTPRouteFilter ... items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (HTTPRouteFilter item : items) {
            HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToFilters(Collection<HTTPRouteFilter> items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (HTTPRouteFilter item : items) {
            HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromFilters(HTTPRouteFilter ... items) {
        for (HTTPRouteFilter item : items) {
            HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);
            this._visitables.get((Object)"filters").remove(builder);
            if (this.filters == null) continue;
            this.filters.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromFilters(Collection<HTTPRouteFilter> items) {
        for (HTTPRouteFilter item : items) {
            HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);
            this._visitables.get((Object)"filters").remove(builder);
            if (this.filters == null) continue;
            this.filters.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromFilters(Predicate<HTTPRouteFilterBuilder> predicate) {
        if (this.filters == null) {
            return (A)this;
        }
        Iterator<HTTPRouteFilterBuilder> each = this.filters.iterator();
        List visitables = this._visitables.get((Object)"filters");
        while (each.hasNext()) {
            HTTPRouteFilterBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HTTPRouteFilter> getFilters() {
        return this.filters != null ? HTTPRouteRuleFluentImpl.build(this.filters) : null;
    }

    @Override
    public List<HTTPRouteFilter> buildFilters() {
        return this.filters != null ? HTTPRouteRuleFluentImpl.build(this.filters) : null;
    }

    @Override
    public HTTPRouteFilter buildFilter(int index) {
        return this.filters.get(index).build();
    }

    @Override
    public HTTPRouteFilter buildFirstFilter() {
        return this.filters.get(0).build();
    }

    @Override
    public HTTPRouteFilter buildLastFilter() {
        return this.filters.get(this.filters.size() - 1).build();
    }

    @Override
    public HTTPRouteFilter buildMatchingFilter(Predicate<HTTPRouteFilterBuilder> predicate) {
        for (HTTPRouteFilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingFilter(Predicate<HTTPRouteFilterBuilder> predicate) {
        for (HTTPRouteFilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withFilters(List<HTTPRouteFilter> filters) {
        if (this.filters != null) {
            this._visitables.get((Object)"filters").clear();
        }
        if (filters != null) {
            this.filters = new ArrayList();
            for (HTTPRouteFilter item : filters) {
                this.addToFilters(item);
            }
        } else {
            this.filters = null;
        }
        return (A)this;
    }

    @Override
    public A withFilters(HTTPRouteFilter ... filters) {
        if (this.filters != null) {
            this.filters.clear();
            this._visitables.remove((Object)"filters");
        }
        if (filters != null) {
            for (HTTPRouteFilter item : filters) {
                this.addToFilters(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasFilters() {
        return this.filters != null && !this.filters.isEmpty();
    }

    @Override
    public HTTPRouteRuleFluent.FiltersNested<A> addNewFilter() {
        return new FiltersNestedImpl();
    }

    @Override
    public HTTPRouteRuleFluent.FiltersNested<A> addNewFilterLike(HTTPRouteFilter item) {
        return new FiltersNestedImpl(-1, item);
    }

    @Override
    public HTTPRouteRuleFluent.FiltersNested<A> setNewFilterLike(int index, HTTPRouteFilter item) {
        return new FiltersNestedImpl(index, item);
    }

    @Override
    public HTTPRouteRuleFluent.FiltersNested<A> editFilter(int index) {
        if (this.filters.size() <= index) {
            throw new RuntimeException("Can't edit filters. Index exceeds size.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    @Override
    public HTTPRouteRuleFluent.FiltersNested<A> editFirstFilter() {
        if (this.filters.size() == 0) {
            throw new RuntimeException("Can't edit first filters. The list is empty.");
        }
        return this.setNewFilterLike(0, this.buildFilter(0));
    }

    @Override
    public HTTPRouteRuleFluent.FiltersNested<A> editLastFilter() {
        int index = this.filters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last filters. The list is empty.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    @Override
    public HTTPRouteRuleFluent.FiltersNested<A> editMatchingFilter(Predicate<HTTPRouteFilterBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.filters.size(); ++i) {
            if (!predicate.test(this.filters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching filters. No match found.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    @Override
    public A addToMatches(int index, HTTPRouteMatch item) {
        if (this.matches == null) {
            this.matches = new ArrayList();
        }
        HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);
        if (index < 0 || index >= this.matches.size()) {
            this._visitables.get((Object)"matches").add(builder);
            this.matches.add(builder);
        } else {
            this._visitables.get((Object)"matches").add(index, builder);
            this.matches.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToMatches(int index, HTTPRouteMatch item) {
        if (this.matches == null) {
            this.matches = new ArrayList();
        }
        HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);
        if (index < 0 || index >= this.matches.size()) {
            this._visitables.get((Object)"matches").add(builder);
            this.matches.add(builder);
        } else {
            this._visitables.get((Object)"matches").set(index, builder);
            this.matches.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMatches(HTTPRouteMatch ... items) {
        if (this.matches == null) {
            this.matches = new ArrayList();
        }
        for (HTTPRouteMatch item : items) {
            HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);
            this._visitables.get((Object)"matches").add(builder);
            this.matches.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMatches(Collection<HTTPRouteMatch> items) {
        if (this.matches == null) {
            this.matches = new ArrayList();
        }
        for (HTTPRouteMatch item : items) {
            HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);
            this._visitables.get((Object)"matches").add(builder);
            this.matches.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMatches(HTTPRouteMatch ... items) {
        for (HTTPRouteMatch item : items) {
            HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);
            this._visitables.get((Object)"matches").remove(builder);
            if (this.matches == null) continue;
            this.matches.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMatches(Collection<HTTPRouteMatch> items) {
        for (HTTPRouteMatch item : items) {
            HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);
            this._visitables.get((Object)"matches").remove(builder);
            if (this.matches == null) continue;
            this.matches.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromMatches(Predicate<HTTPRouteMatchBuilder> predicate) {
        if (this.matches == null) {
            return (A)this;
        }
        Iterator<HTTPRouteMatchBuilder> each = this.matches.iterator();
        List visitables = this._visitables.get((Object)"matches");
        while (each.hasNext()) {
            HTTPRouteMatchBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HTTPRouteMatch> getMatches() {
        return this.matches != null ? HTTPRouteRuleFluentImpl.build(this.matches) : null;
    }

    @Override
    public List<HTTPRouteMatch> buildMatches() {
        return this.matches != null ? HTTPRouteRuleFluentImpl.build(this.matches) : null;
    }

    @Override
    public HTTPRouteMatch buildMatch(int index) {
        return this.matches.get(index).build();
    }

    @Override
    public HTTPRouteMatch buildFirstMatch() {
        return this.matches.get(0).build();
    }

    @Override
    public HTTPRouteMatch buildLastMatch() {
        return this.matches.get(this.matches.size() - 1).build();
    }

    @Override
    public HTTPRouteMatch buildMatchingMatch(Predicate<HTTPRouteMatchBuilder> predicate) {
        for (HTTPRouteMatchBuilder item : this.matches) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMatch(Predicate<HTTPRouteMatchBuilder> predicate) {
        for (HTTPRouteMatchBuilder item : this.matches) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMatches(List<HTTPRouteMatch> matches) {
        if (this.matches != null) {
            this._visitables.get((Object)"matches").clear();
        }
        if (matches != null) {
            this.matches = new ArrayList();
            for (HTTPRouteMatch item : matches) {
                this.addToMatches(item);
            }
        } else {
            this.matches = null;
        }
        return (A)this;
    }

    @Override
    public A withMatches(HTTPRouteMatch ... matches) {
        if (this.matches != null) {
            this.matches.clear();
            this._visitables.remove((Object)"matches");
        }
        if (matches != null) {
            for (HTTPRouteMatch item : matches) {
                this.addToMatches(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMatches() {
        return this.matches != null && !this.matches.isEmpty();
    }

    @Override
    public HTTPRouteRuleFluent.MatchesNested<A> addNewMatch() {
        return new MatchesNestedImpl();
    }

    @Override
    public HTTPRouteRuleFluent.MatchesNested<A> addNewMatchLike(HTTPRouteMatch item) {
        return new MatchesNestedImpl(-1, item);
    }

    @Override
    public HTTPRouteRuleFluent.MatchesNested<A> setNewMatchLike(int index, HTTPRouteMatch item) {
        return new MatchesNestedImpl(index, item);
    }

    @Override
    public HTTPRouteRuleFluent.MatchesNested<A> editMatch(int index) {
        if (this.matches.size() <= index) {
            throw new RuntimeException("Can't edit matches. Index exceeds size.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    @Override
    public HTTPRouteRuleFluent.MatchesNested<A> editFirstMatch() {
        if (this.matches.size() == 0) {
            throw new RuntimeException("Can't edit first matches. The list is empty.");
        }
        return this.setNewMatchLike(0, this.buildMatch(0));
    }

    @Override
    public HTTPRouteRuleFluent.MatchesNested<A> editLastMatch() {
        int index = this.matches.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last matches. The list is empty.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    @Override
    public HTTPRouteRuleFluent.MatchesNested<A> editMatchingMatch(Predicate<HTTPRouteMatchBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matches.size(); ++i) {
            if (!predicate.test(this.matches.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching matches. No match found.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPRouteRuleFluentImpl that = (HTTPRouteRuleFluentImpl)o;
        if (!Objects.equals(this.backendRefs, that.backendRefs)) {
            return false;
        }
        if (!Objects.equals(this.filters, that.filters)) {
            return false;
        }
        if (!Objects.equals(this.matches, that.matches)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.backendRefs, this.filters, this.matches, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.backendRefs != null) {
            sb.append("backendRefs:");
            sb.append(this.backendRefs + ",");
        }
        if (this.filters != null) {
            sb.append("filters:");
            sb.append(this.filters + ",");
        }
        if (this.matches != null) {
            sb.append("matches:");
            sb.append(this.matches + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class MatchesNestedImpl<N>
    extends HTTPRouteMatchFluentImpl<HTTPRouteRuleFluent.MatchesNested<N>>
    implements HTTPRouteRuleFluent.MatchesNested<N>,
    Nested<N> {
        HTTPRouteMatchBuilder builder;
        int index;

        MatchesNestedImpl(int index, HTTPRouteMatch item) {
            this.index = index;
            this.builder = new HTTPRouteMatchBuilder(this, item);
        }

        MatchesNestedImpl() {
            this.index = -1;
            this.builder = new HTTPRouteMatchBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPRouteRuleFluentImpl.this.setToMatches(this.index, this.builder.build());
        }

        @Override
        public N endMatch() {
            return this.and();
        }
    }

    class FiltersNestedImpl<N>
    extends HTTPRouteFilterFluentImpl<HTTPRouteRuleFluent.FiltersNested<N>>
    implements HTTPRouteRuleFluent.FiltersNested<N>,
    Nested<N> {
        HTTPRouteFilterBuilder builder;
        int index;

        FiltersNestedImpl(int index, HTTPRouteFilter item) {
            this.index = index;
            this.builder = new HTTPRouteFilterBuilder(this, item);
        }

        FiltersNestedImpl() {
            this.index = -1;
            this.builder = new HTTPRouteFilterBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPRouteRuleFluentImpl.this.setToFilters(this.index, this.builder.build());
        }

        @Override
        public N endFilter() {
            return this.and();
        }
    }

    class BackendRefsNestedImpl<N>
    extends HTTPBackendRefFluentImpl<HTTPRouteRuleFluent.BackendRefsNested<N>>
    implements HTTPRouteRuleFluent.BackendRefsNested<N>,
    Nested<N> {
        HTTPBackendRefBuilder builder;
        int index;

        BackendRefsNestedImpl(int index, HTTPBackendRef item) {
            this.index = index;
            this.builder = new HTTPBackendRefBuilder(this, item);
        }

        BackendRefsNestedImpl() {
            this.index = -1;
            this.builder = new HTTPBackendRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPRouteRuleFluentImpl.this.setToBackendRefs(this.index, this.builder.build());
        }

        @Override
        public N endBackendRef() {
            return this.and();
        }
    }
}

