package io.fabric8.kubernetes.api.model.clusterapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachineBuilder extends MachineFluent<MachineBuilder> implements VisitableBuilder<Machine,MachineBuilder>{
  public MachineBuilder() {
    this(new Machine());
  }
  
  public MachineBuilder(MachineFluent<?> fluent) {
    this(fluent, new Machine());
  }
  
  public MachineBuilder(MachineFluent<?> fluent,Machine instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachineBuilder(Machine instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachineFluent<?> fluent;
  
  public Machine build() {
    Machine buildable = new Machine(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}