package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PersistentVolumeBuilder extends PersistentVolumeFluent<PersistentVolumeBuilder> implements VisitableBuilder<PersistentVolume,PersistentVolumeBuilder>{
  public PersistentVolumeBuilder() {
    this(new PersistentVolume());
  }
  
  public PersistentVolumeBuilder(PersistentVolumeFluent<?> fluent) {
    this(fluent, new PersistentVolume());
  }
  
  public PersistentVolumeBuilder(PersistentVolumeFluent<?> fluent,PersistentVolume instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PersistentVolumeBuilder(PersistentVolume instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PersistentVolumeFluent<?> fluent;
  
  public PersistentVolume build() {
    PersistentVolume buildable = new PersistentVolume(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}