package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class LoadBalancerIngressBuilder extends LoadBalancerIngressFluent<LoadBalancerIngressBuilder> implements VisitableBuilder<LoadBalancerIngress,LoadBalancerIngressBuilder>{
  public LoadBalancerIngressBuilder() {
    this(new LoadBalancerIngress());
  }
  
  public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent) {
    this(fluent, new LoadBalancerIngress());
  }
  
  public LoadBalancerIngressBuilder(LoadBalancerIngressFluent<?> fluent,LoadBalancerIngress instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public LoadBalancerIngressBuilder(LoadBalancerIngress instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  LoadBalancerIngressFluent<?> fluent;
  
  public LoadBalancerIngress build() {
    LoadBalancerIngress buildable = new LoadBalancerIngress(fluent.getHostname(),fluent.getIp(),fluent.getIpMode(),fluent.buildPorts());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}