/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.clusterapi.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.Bootstrap;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.BootstrapBuilder;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.BootstrapFluent;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MachineSpecFluent<A extends MachineSpecFluent<A>>
extends BaseFluent<A> {
    private BootstrapBuilder bootstrap;
    private String clusterName;
    private String failureDomain;
    private ObjectReferenceBuilder infrastructureRef;
    private Duration nodeDeletionTimeout;
    private Duration nodeDrainTimeout;
    private Duration nodeVolumeDetachTimeout;
    private String providerID;
    private String version;
    private Map<String, Object> additionalProperties;

    public MachineSpecFluent() {
    }

    public MachineSpecFluent(MachineSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachineSpec instance) {
        MachineSpec machineSpec = instance = instance != null ? instance : new MachineSpec();
        if (instance != null) {
            this.withBootstrap(instance.getBootstrap());
            this.withClusterName(instance.getClusterName());
            this.withFailureDomain(instance.getFailureDomain());
            this.withInfrastructureRef(instance.getInfrastructureRef());
            this.withNodeDeletionTimeout(instance.getNodeDeletionTimeout());
            this.withNodeDrainTimeout(instance.getNodeDrainTimeout());
            this.withNodeVolumeDetachTimeout(instance.getNodeVolumeDetachTimeout());
            this.withProviderID(instance.getProviderID());
            this.withVersion(instance.getVersion());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Bootstrap buildBootstrap() {
        return this.bootstrap != null ? this.bootstrap.build() : null;
    }

    public A withBootstrap(Bootstrap bootstrap) {
        this._visitables.remove((Object)"bootstrap");
        if (bootstrap != null) {
            this.bootstrap = new BootstrapBuilder(bootstrap);
            this._visitables.get((Object)"bootstrap").add(this.bootstrap);
        } else {
            this.bootstrap = null;
            this._visitables.get((Object)"bootstrap").remove((Object)this.bootstrap);
        }
        return (A)((Object)this);
    }

    public boolean hasBootstrap() {
        return this.bootstrap != null;
    }

    public BootstrapNested<A> withNewBootstrap() {
        return new BootstrapNested(null);
    }

    public BootstrapNested<A> withNewBootstrapLike(Bootstrap item) {
        return new BootstrapNested(item);
    }

    public BootstrapNested<A> editBootstrap() {
        return this.withNewBootstrapLike(Optional.ofNullable(this.buildBootstrap()).orElse(null));
    }

    public BootstrapNested<A> editOrNewBootstrap() {
        return this.withNewBootstrapLike(Optional.ofNullable(this.buildBootstrap()).orElse(new BootstrapBuilder().build()));
    }

    public BootstrapNested<A> editOrNewBootstrapLike(Bootstrap item) {
        return this.withNewBootstrapLike(Optional.ofNullable(this.buildBootstrap()).orElse(item));
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public A withClusterName(String clusterName) {
        this.clusterName = clusterName;
        return (A)((Object)this);
    }

    public boolean hasClusterName() {
        return this.clusterName != null;
    }

    public String getFailureDomain() {
        return this.failureDomain;
    }

    public A withFailureDomain(String failureDomain) {
        this.failureDomain = failureDomain;
        return (A)((Object)this);
    }

    public boolean hasFailureDomain() {
        return this.failureDomain != null;
    }

    public ObjectReference buildInfrastructureRef() {
        return this.infrastructureRef != null ? this.infrastructureRef.build() : null;
    }

    public A withInfrastructureRef(ObjectReference infrastructureRef) {
        this._visitables.remove((Object)"infrastructureRef");
        if (infrastructureRef != null) {
            this.infrastructureRef = new ObjectReferenceBuilder(infrastructureRef);
            this._visitables.get((Object)"infrastructureRef").add(this.infrastructureRef);
        } else {
            this.infrastructureRef = null;
            this._visitables.get((Object)"infrastructureRef").remove((Object)this.infrastructureRef);
        }
        return (A)((Object)this);
    }

    public boolean hasInfrastructureRef() {
        return this.infrastructureRef != null;
    }

    public InfrastructureRefNested<A> withNewInfrastructureRef() {
        return new InfrastructureRefNested(null);
    }

    public InfrastructureRefNested<A> withNewInfrastructureRefLike(ObjectReference item) {
        return new InfrastructureRefNested(item);
    }

    public InfrastructureRefNested<A> editInfrastructureRef() {
        return this.withNewInfrastructureRefLike(Optional.ofNullable(this.buildInfrastructureRef()).orElse(null));
    }

    public InfrastructureRefNested<A> editOrNewInfrastructureRef() {
        return this.withNewInfrastructureRefLike(Optional.ofNullable(this.buildInfrastructureRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public InfrastructureRefNested<A> editOrNewInfrastructureRefLike(ObjectReference item) {
        return this.withNewInfrastructureRefLike(Optional.ofNullable(this.buildInfrastructureRef()).orElse(item));
    }

    public Duration getNodeDeletionTimeout() {
        return this.nodeDeletionTimeout;
    }

    public A withNodeDeletionTimeout(Duration nodeDeletionTimeout) {
        this.nodeDeletionTimeout = nodeDeletionTimeout;
        return (A)((Object)this);
    }

    public boolean hasNodeDeletionTimeout() {
        return this.nodeDeletionTimeout != null;
    }

    public Duration getNodeDrainTimeout() {
        return this.nodeDrainTimeout;
    }

    public A withNodeDrainTimeout(Duration nodeDrainTimeout) {
        this.nodeDrainTimeout = nodeDrainTimeout;
        return (A)((Object)this);
    }

    public boolean hasNodeDrainTimeout() {
        return this.nodeDrainTimeout != null;
    }

    public Duration getNodeVolumeDetachTimeout() {
        return this.nodeVolumeDetachTimeout;
    }

    public A withNodeVolumeDetachTimeout(Duration nodeVolumeDetachTimeout) {
        this.nodeVolumeDetachTimeout = nodeVolumeDetachTimeout;
        return (A)((Object)this);
    }

    public boolean hasNodeVolumeDetachTimeout() {
        return this.nodeVolumeDetachTimeout != null;
    }

    public String getProviderID() {
        return this.providerID;
    }

    public A withProviderID(String providerID) {
        this.providerID = providerID;
        return (A)((Object)this);
    }

    public boolean hasProviderID() {
        return this.providerID != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineSpecFluent that = (MachineSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.bootstrap, (Object)that.bootstrap)) {
            return false;
        }
        if (!Objects.equals(this.clusterName, that.clusterName)) {
            return false;
        }
        if (!Objects.equals(this.failureDomain, that.failureDomain)) {
            return false;
        }
        if (!Objects.equals((Object)this.infrastructureRef, (Object)that.infrastructureRef)) {
            return false;
        }
        if (!Objects.equals(this.nodeDeletionTimeout, that.nodeDeletionTimeout)) {
            return false;
        }
        if (!Objects.equals(this.nodeDrainTimeout, that.nodeDrainTimeout)) {
            return false;
        }
        if (!Objects.equals(this.nodeVolumeDetachTimeout, that.nodeVolumeDetachTimeout)) {
            return false;
        }
        if (!Objects.equals(this.providerID, that.providerID)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bootstrap, this.clusterName, this.failureDomain, this.infrastructureRef, this.nodeDeletionTimeout, this.nodeDrainTimeout, this.nodeVolumeDetachTimeout, this.providerID, this.version, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bootstrap != null) {
            sb.append("bootstrap:");
            sb.append(this.bootstrap + ",");
        }
        if (this.clusterName != null) {
            sb.append("clusterName:");
            sb.append(this.clusterName + ",");
        }
        if (this.failureDomain != null) {
            sb.append("failureDomain:");
            sb.append(this.failureDomain + ",");
        }
        if (this.infrastructureRef != null) {
            sb.append("infrastructureRef:");
            sb.append(this.infrastructureRef + ",");
        }
        if (this.nodeDeletionTimeout != null) {
            sb.append("nodeDeletionTimeout:");
            sb.append(this.nodeDeletionTimeout + ",");
        }
        if (this.nodeDrainTimeout != null) {
            sb.append("nodeDrainTimeout:");
            sb.append(this.nodeDrainTimeout + ",");
        }
        if (this.nodeVolumeDetachTimeout != null) {
            sb.append("nodeVolumeDetachTimeout:");
            sb.append(this.nodeVolumeDetachTimeout + ",");
        }
        if (this.providerID != null) {
            sb.append("providerID:");
            sb.append(this.providerID + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class InfrastructureRefNested<N>
    extends ObjectReferenceFluent<InfrastructureRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        InfrastructureRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)MachineSpecFluent.this.withInfrastructureRef(this.builder.build());
        }

        public N endInfrastructureRef() {
            return this.and();
        }
    }

    public class BootstrapNested<N>
    extends BootstrapFluent<BootstrapNested<N>>
    implements Nested<N> {
        BootstrapBuilder builder;

        BootstrapNested(Bootstrap item) {
            this.builder = new BootstrapBuilder(this, item);
        }

        public N and() {
            return (N)MachineSpecFluent.this.withBootstrap(this.builder.build());
        }

        public N endBootstrap() {
            return this.and();
        }
    }
}

