/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ScopeSelector;
import io.fabric8.kubernetes.api.model.ScopedResourceSelectorRequirement;
import io.fabric8.kubernetes.api.model.ScopedResourceSelectorRequirementBuilder;
import io.fabric8.kubernetes.api.model.ScopedResourceSelectorRequirementFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ScopeSelectorFluent<A extends ScopeSelectorFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ScopedResourceSelectorRequirementBuilder> matchExpressions = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ScopeSelectorFluent() {
    }

    public ScopeSelectorFluent(ScopeSelector instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ScopeSelector instance) {
        ScopeSelector scopeSelector = instance = instance != null ? instance : new ScopeSelector();
        if (instance != null) {
            this.withMatchExpressions(instance.getMatchExpressions());
            this.withMatchExpressions(instance.getMatchExpressions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToMatchExpressions(int index, ScopedResourceSelectorRequirement item) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        ScopedResourceSelectorRequirementBuilder builder = new ScopedResourceSelectorRequirementBuilder(item);
        if (index < 0 || index >= this.matchExpressions.size()) {
            this._visitables.get((Object)"matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        } else {
            this._visitables.get((Object)"matchExpressions").add(index, builder);
            this.matchExpressions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToMatchExpressions(int index, ScopedResourceSelectorRequirement item) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        ScopedResourceSelectorRequirementBuilder builder = new ScopedResourceSelectorRequirementBuilder(item);
        if (index < 0 || index >= this.matchExpressions.size()) {
            this._visitables.get((Object)"matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        } else {
            this._visitables.get((Object)"matchExpressions").set(index, builder);
            this.matchExpressions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToMatchExpressions(ScopedResourceSelectorRequirement ... items) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        for (ScopedResourceSelectorRequirement item : items) {
            ScopedResourceSelectorRequirementBuilder builder = new ScopedResourceSelectorRequirementBuilder(item);
            this._visitables.get((Object)"matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToMatchExpressions(Collection<ScopedResourceSelectorRequirement> items) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        for (ScopedResourceSelectorRequirement item : items) {
            ScopedResourceSelectorRequirementBuilder builder = new ScopedResourceSelectorRequirementBuilder(item);
            this._visitables.get((Object)"matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromMatchExpressions(ScopedResourceSelectorRequirement ... items) {
        if (this.matchExpressions == null) {
            return (A)((Object)this);
        }
        for (ScopedResourceSelectorRequirement item : items) {
            ScopedResourceSelectorRequirementBuilder builder = new ScopedResourceSelectorRequirementBuilder(item);
            this._visitables.get((Object)"matchExpressions").remove((Object)builder);
            this.matchExpressions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMatchExpressions(Collection<ScopedResourceSelectorRequirement> items) {
        if (this.matchExpressions == null) {
            return (A)((Object)this);
        }
        for (ScopedResourceSelectorRequirement item : items) {
            ScopedResourceSelectorRequirementBuilder builder = new ScopedResourceSelectorRequirementBuilder(item);
            this._visitables.get((Object)"matchExpressions").remove((Object)builder);
            this.matchExpressions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMatchExpressions(Predicate<ScopedResourceSelectorRequirementBuilder> predicate) {
        if (this.matchExpressions == null) {
            return (A)((Object)this);
        }
        Iterator<ScopedResourceSelectorRequirementBuilder> each = this.matchExpressions.iterator();
        List visitables = this._visitables.get((Object)"matchExpressions");
        while (each.hasNext()) {
            ScopedResourceSelectorRequirementBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ScopedResourceSelectorRequirement> buildMatchExpressions() {
        return this.matchExpressions != null ? ScopeSelectorFluent.build(this.matchExpressions) : null;
    }

    public ScopedResourceSelectorRequirement buildMatchExpression(int index) {
        return this.matchExpressions.get(index).build();
    }

    public ScopedResourceSelectorRequirement buildFirstMatchExpression() {
        return this.matchExpressions.get(0).build();
    }

    public ScopedResourceSelectorRequirement buildLastMatchExpression() {
        return this.matchExpressions.get(this.matchExpressions.size() - 1).build();
    }

    public ScopedResourceSelectorRequirement buildMatchingMatchExpression(Predicate<ScopedResourceSelectorRequirementBuilder> predicate) {
        for (ScopedResourceSelectorRequirementBuilder item : this.matchExpressions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMatchExpression(Predicate<ScopedResourceSelectorRequirementBuilder> predicate) {
        for (ScopedResourceSelectorRequirementBuilder item : this.matchExpressions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMatchExpressions(List<ScopedResourceSelectorRequirement> matchExpressions) {
        if (this.matchExpressions != null) {
            this._visitables.get((Object)"matchExpressions").clear();
        }
        if (matchExpressions != null) {
            this.matchExpressions = new ArrayList();
            for (ScopedResourceSelectorRequirement item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        } else {
            this.matchExpressions = null;
        }
        return (A)((Object)this);
    }

    public A withMatchExpressions(ScopedResourceSelectorRequirement ... matchExpressions) {
        if (this.matchExpressions != null) {
            this.matchExpressions.clear();
            this._visitables.remove((Object)"matchExpressions");
        }
        if (matchExpressions != null) {
            for (ScopedResourceSelectorRequirement item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMatchExpressions() {
        return this.matchExpressions != null && !this.matchExpressions.isEmpty();
    }

    public MatchExpressionsNested<A> addNewMatchExpression() {
        return new MatchExpressionsNested(-1, null);
    }

    public MatchExpressionsNested<A> addNewMatchExpressionLike(ScopedResourceSelectorRequirement item) {
        return new MatchExpressionsNested(-1, item);
    }

    public MatchExpressionsNested<A> setNewMatchExpressionLike(int index, ScopedResourceSelectorRequirement item) {
        return new MatchExpressionsNested(index, item);
    }

    public MatchExpressionsNested<A> editMatchExpression(int index) {
        if (this.matchExpressions.size() <= index) {
            throw new RuntimeException("Can't edit matchExpressions. Index exceeds size.");
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    public MatchExpressionsNested<A> editFirstMatchExpression() {
        if (this.matchExpressions.size() == 0) {
            throw new RuntimeException("Can't edit first matchExpressions. The list is empty.");
        }
        return this.setNewMatchExpressionLike(0, this.buildMatchExpression(0));
    }

    public MatchExpressionsNested<A> editLastMatchExpression() {
        int index = this.matchExpressions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last matchExpressions. The list is empty.");
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    public MatchExpressionsNested<A> editMatchingMatchExpression(Predicate<ScopedResourceSelectorRequirementBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matchExpressions.size(); ++i) {
            if (!predicate.test(this.matchExpressions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching matchExpressions. No match found.");
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScopeSelectorFluent that = (ScopeSelectorFluent)((Object)o);
        if (!Objects.equals(this.matchExpressions, that.matchExpressions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.matchExpressions, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.matchExpressions != null && !this.matchExpressions.isEmpty()) {
            sb.append("matchExpressions:");
            sb.append(this.matchExpressions + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MatchExpressionsNested<N>
    extends ScopedResourceSelectorRequirementFluent<MatchExpressionsNested<N>>
    implements Nested<N> {
        ScopedResourceSelectorRequirementBuilder builder;
        int index;

        MatchExpressionsNested(int index, ScopedResourceSelectorRequirement item) {
            this.index = index;
            this.builder = new ScopedResourceSelectorRequirementBuilder(this, item);
        }

        public N and() {
            return (N)ScopeSelectorFluent.this.setToMatchExpressions(this.index, this.builder.build());
        }

        public N endMatchExpression() {
            return this.and();
        }
    }
}

