/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NodeAffinity;
import io.fabric8.kubernetes.api.model.NodeAffinityFluent;
import io.fabric8.kubernetes.api.model.NodeAffinityFluentImpl;
import java.util.Objects;

public class NodeAffinityBuilder
extends NodeAffinityFluentImpl<NodeAffinityBuilder>
implements VisitableBuilder<NodeAffinity, NodeAffinityBuilder> {
    NodeAffinityFluent<?> fluent;
    Boolean validationEnabled;

    public NodeAffinityBuilder() {
        this(false);
    }

    public NodeAffinityBuilder(Boolean validationEnabled) {
        this(new NodeAffinity(), validationEnabled);
    }

    public NodeAffinityBuilder(NodeAffinityFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NodeAffinityBuilder(NodeAffinityFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NodeAffinity(), validationEnabled);
    }

    public NodeAffinityBuilder(NodeAffinityFluent<?> fluent, NodeAffinity instance) {
        this(fluent, instance, false);
    }

    public NodeAffinityBuilder(NodeAffinityFluent<?> fluent, NodeAffinity instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution());
        fluent.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution());
        this.validationEnabled = validationEnabled;
    }

    public NodeAffinityBuilder(NodeAffinity instance) {
        this(instance, (Boolean)false);
    }

    public NodeAffinityBuilder(NodeAffinity instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution());
        this.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NodeAffinity build() {
        NodeAffinity buildable = new NodeAffinity(this.fluent.getPreferredDuringSchedulingIgnoredDuringExecution(), this.fluent.getRequiredDuringSchedulingIgnoredDuringExecution());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeAffinityBuilder that = (NodeAffinityBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

