/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.certificates.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CertificateSigningRequestSpecFluent<A extends CertificateSigningRequestSpecFluent<A>>
extends BaseFluent<A> {
    private Integer expirationSeconds;
    private Map<String, ArrayList<String>> extra;
    private List<String> groups = new ArrayList<String>();
    private String request;
    private String signerName;
    private String uid;
    private List<String> usages = new ArrayList<String>();
    private String username;
    private Map<String, Object> additionalProperties;

    public CertificateSigningRequestSpecFluent() {
    }

    public CertificateSigningRequestSpecFluent(CertificateSigningRequestSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CertificateSigningRequestSpec instance) {
        CertificateSigningRequestSpec certificateSigningRequestSpec = instance = instance != null ? instance : new CertificateSigningRequestSpec();
        if (instance != null) {
            this.withExpirationSeconds(instance.getExpirationSeconds());
            this.withExtra(instance.getExtra());
            this.withGroups(instance.getGroups());
            this.withRequest(instance.getRequest());
            this.withSignerName(instance.getSignerName());
            this.withUid(instance.getUid());
            this.withUsages(instance.getUsages());
            this.withUsername(instance.getUsername());
            this.withExpirationSeconds(instance.getExpirationSeconds());
            this.withExtra(instance.getExtra());
            this.withGroups(instance.getGroups());
            this.withRequest(instance.getRequest());
            this.withSignerName(instance.getSignerName());
            this.withUid(instance.getUid());
            this.withUsages(instance.getUsages());
            this.withUsername(instance.getUsername());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getExpirationSeconds() {
        return this.expirationSeconds;
    }

    public A withExpirationSeconds(Integer expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
        return (A)((Object)this);
    }

    public boolean hasExpirationSeconds() {
        return this.expirationSeconds != null;
    }

    public A addToExtra(String key, ArrayList<String> value) {
        if (this.extra == null && key != null && value != null) {
            this.extra = new LinkedHashMap<String, ArrayList<String>>();
        }
        if (key != null && value != null) {
            this.extra.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToExtra(Map<String, ArrayList<String>> map) {
        if (this.extra == null && map != null) {
            this.extra = new LinkedHashMap<String, ArrayList<String>>();
        }
        if (map != null) {
            this.extra.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromExtra(String key) {
        if (this.extra == null) {
            return (A)((Object)this);
        }
        if (key != null && this.extra != null) {
            this.extra.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromExtra(Map<String, ArrayList<String>> map) {
        if (this.extra == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.extra == null) continue;
                this.extra.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, ArrayList<String>> getExtra() {
        return this.extra;
    }

    public <K, V> A withExtra(Map<String, ArrayList<String>> extra) {
        this.extra = extra == null ? null : new LinkedHashMap<String, ArrayList<String>>(extra);
        return (A)((Object)this);
    }

    public boolean hasExtra() {
        return this.extra != null;
    }

    public A addToGroups(int index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(index, item);
        return (A)((Object)this);
    }

    public A setToGroups(int index, String item) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.set(index, item);
        return (A)((Object)this);
    }

    public A addToGroups(String ... items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToGroups(Collection<String> items) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromGroups(String ... items) {
        if (this.groups == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.groups.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromGroups(Collection<String> items) {
        if (this.groups == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.groups.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String getGroup(int index) {
        return this.groups.get(index);
    }

    public String getFirstGroup() {
        return this.groups.get(0);
    }

    public String getLastGroup() {
        return this.groups.get(this.groups.size() - 1);
    }

    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGroups(List<String> groups) {
        if (groups != null) {
            this.groups = new ArrayList<String>();
            for (String item : groups) {
                this.addToGroups(item);
            }
        } else {
            this.groups = null;
        }
        return (A)((Object)this);
    }

    public A withGroups(String ... groups) {
        if (this.groups != null) {
            this.groups.clear();
            this._visitables.remove((Object)"groups");
        }
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    public String getRequest() {
        return this.request;
    }

    public A withRequest(String request) {
        this.request = request;
        return (A)((Object)this);
    }

    public boolean hasRequest() {
        return this.request != null;
    }

    public String getSignerName() {
        return this.signerName;
    }

    public A withSignerName(String signerName) {
        this.signerName = signerName;
        return (A)((Object)this);
    }

    public boolean hasSignerName() {
        return this.signerName != null;
    }

    public String getUid() {
        return this.uid;
    }

    public A withUid(String uid) {
        this.uid = uid;
        return (A)((Object)this);
    }

    public boolean hasUid() {
        return this.uid != null;
    }

    public A addToUsages(int index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.add(index, item);
        return (A)((Object)this);
    }

    public A setToUsages(int index, String item) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        this.usages.set(index, item);
        return (A)((Object)this);
    }

    public A addToUsages(String ... items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToUsages(Collection<String> items) {
        if (this.usages == null) {
            this.usages = new ArrayList<String>();
        }
        for (String item : items) {
            this.usages.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromUsages(String ... items) {
        if (this.usages == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.usages.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromUsages(Collection<String> items) {
        if (this.usages == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.usages.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getUsages() {
        return this.usages;
    }

    public String getUsage(int index) {
        return this.usages.get(index);
    }

    public String getFirstUsage() {
        return this.usages.get(0);
    }

    public String getLastUsage() {
        return this.usages.get(this.usages.size() - 1);
    }

    public String getMatchingUsage(Predicate<String> predicate) {
        for (String item : this.usages) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingUsage(Predicate<String> predicate) {
        for (String item : this.usages) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUsages(List<String> usages) {
        if (usages != null) {
            this.usages = new ArrayList<String>();
            for (String item : usages) {
                this.addToUsages(item);
            }
        } else {
            this.usages = null;
        }
        return (A)((Object)this);
    }

    public A withUsages(String ... usages) {
        if (this.usages != null) {
            this.usages.clear();
            this._visitables.remove((Object)"usages");
        }
        if (usages != null) {
            for (String item : usages) {
                this.addToUsages(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasUsages() {
        return this.usages != null && !this.usages.isEmpty();
    }

    public String getUsername() {
        return this.username;
    }

    public A withUsername(String username) {
        this.username = username;
        return (A)((Object)this);
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CertificateSigningRequestSpecFluent that = (CertificateSigningRequestSpecFluent)((Object)o);
        if (!Objects.equals(this.expirationSeconds, that.expirationSeconds)) {
            return false;
        }
        if (!Objects.equals(this.extra, that.extra)) {
            return false;
        }
        if (!Objects.equals(this.groups, that.groups)) {
            return false;
        }
        if (!Objects.equals(this.request, that.request)) {
            return false;
        }
        if (!Objects.equals(this.signerName, that.signerName)) {
            return false;
        }
        if (!Objects.equals(this.uid, that.uid)) {
            return false;
        }
        if (!Objects.equals(this.usages, that.usages)) {
            return false;
        }
        if (!Objects.equals(this.username, that.username)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.expirationSeconds, this.extra, this.groups, this.request, this.signerName, this.uid, this.usages, this.username, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.expirationSeconds != null) {
            sb.append("expirationSeconds:");
            sb.append(this.expirationSeconds + ",");
        }
        if (this.extra != null && !this.extra.isEmpty()) {
            sb.append("extra:");
            sb.append(this.extra + ",");
        }
        if (this.groups != null && !this.groups.isEmpty()) {
            sb.append("groups:");
            sb.append(this.groups + ",");
        }
        if (this.request != null) {
            sb.append("request:");
            sb.append(this.request + ",");
        }
        if (this.signerName != null) {
            sb.append("signerName:");
            sb.append(this.signerName + ",");
        }
        if (this.uid != null) {
            sb.append("uid:");
            sb.append(this.uid + ",");
        }
        if (this.usages != null && !this.usages.isEmpty()) {
            sb.append("usages:");
            sb.append(this.usages + ",");
        }
        if (this.username != null) {
            sb.append("username:");
            sb.append(this.username + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

