package io.fabric8.kubernetes.api.model.batch.v1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SuccessPolicyRuleFluent<A extends SuccessPolicyRuleFluent<A>> extends BaseFluent<A>{
  public SuccessPolicyRuleFluent() {
  }
  
  public SuccessPolicyRuleFluent(SuccessPolicyRule instance) {
    this.copyInstance(instance);
  }
  private Integer succeededCount;
  private String succeededIndexes;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SuccessPolicyRule instance) {
    instance = (instance != null ? instance : new SuccessPolicyRule());
    if (instance != null) {
          this.withSucceededCount(instance.getSucceededCount());
          this.withSucceededIndexes(instance.getSucceededIndexes());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Integer getSucceededCount() {
    return this.succeededCount;
  }
  
  public A withSucceededCount(Integer succeededCount) {
    this.succeededCount = succeededCount;
    return (A) this;
  }
  
  public boolean hasSucceededCount() {
    return this.succeededCount != null;
  }
  
  public String getSucceededIndexes() {
    return this.succeededIndexes;
  }
  
  public A withSucceededIndexes(String succeededIndexes) {
    this.succeededIndexes = succeededIndexes;
    return (A) this;
  }
  
  public boolean hasSucceededIndexes() {
    return this.succeededIndexes != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SuccessPolicyRuleFluent that = (SuccessPolicyRuleFluent) o;
    if (!java.util.Objects.equals(succeededCount, that.succeededCount)) return false;
    if (!java.util.Objects.equals(succeededIndexes, that.succeededIndexes)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(succeededCount,  succeededIndexes,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (succeededCount != null) { sb.append("succeededCount:"); sb.append(succeededCount + ","); }
    if (succeededIndexes != null) { sb.append("succeededIndexes:"); sb.append(succeededIndexes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}