package io.fabric8.kubernetes.api.model.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MetricValueStatusBuilder extends MetricValueStatusFluent<MetricValueStatusBuilder> implements VisitableBuilder<MetricValueStatus,MetricValueStatusBuilder>{
  public MetricValueStatusBuilder() {
    this(new MetricValueStatus());
  }
  
  public MetricValueStatusBuilder(MetricValueStatusFluent<?> fluent) {
    this(fluent, new MetricValueStatus());
  }
  
  public MetricValueStatusBuilder(MetricValueStatusFluent<?> fluent,MetricValueStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MetricValueStatusBuilder(MetricValueStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MetricValueStatusFluent<?> fluent;
  
  public MetricValueStatus build() {
    MetricValueStatus buildable = new MetricValueStatus(fluent.getAverageUtilization(),fluent.getAverageValue(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}