/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricStatus;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.PodsMetricStatusFluent;
import java.util.Objects;

public class PodsMetricStatusFluentImpl<A extends PodsMetricStatusFluent<A>>
extends BaseFluent<A>
implements PodsMetricStatusFluent<A> {
    private Quantity currentAverageValue;
    private String metricName;
    private LabelSelectorBuilder selector;

    public PodsMetricStatusFluentImpl() {
    }

    public PodsMetricStatusFluentImpl(PodsMetricStatus instance) {
        this.withCurrentAverageValue(instance.getCurrentAverageValue());
        this.withMetricName(instance.getMetricName());
        this.withSelector(instance.getSelector());
    }

    @Override
    public Quantity getCurrentAverageValue() {
        return this.currentAverageValue;
    }

    @Override
    public A withCurrentAverageValue(Quantity currentAverageValue) {
        this.currentAverageValue = currentAverageValue;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentAverageValue() {
        return this.currentAverageValue != null;
    }

    @Override
    public A withNewCurrentAverageValue(String amount, String format) {
        return this.withCurrentAverageValue(new Quantity(amount, format));
    }

    @Override
    public A withNewCurrentAverageValue(String amount) {
        return this.withCurrentAverageValue(new Quantity(amount));
    }

    @Override
    public String getMetricName() {
        return this.metricName;
    }

    @Override
    public A withMetricName(String metricName) {
        this.metricName = metricName;
        return (A)this;
    }

    @Override
    public Boolean hasMetricName() {
        return this.metricName != null;
    }

    @Override
    @Deprecated
    public A withNewMetricName(String arg0) {
        return this.withMetricName(new String(arg0));
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.get((Object)"selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public PodsMetricStatusFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public PodsMetricStatusFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public PodsMetricStatusFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public PodsMetricStatusFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public PodsMetricStatusFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodsMetricStatusFluentImpl that = (PodsMetricStatusFluentImpl)o;
        if (this.currentAverageValue != null ? !this.currentAverageValue.equals((Object)that.currentAverageValue) : that.currentAverageValue != null) {
            return false;
        }
        if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) {
            return false;
        }
        return !(this.selector != null ? !this.selector.equals((Object)that.selector) : that.selector != null);
    }

    public int hashCode() {
        return Objects.hash(this.currentAverageValue, this.metricName, this.selector, super.hashCode());
    }

    public class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<PodsMetricStatusFluent.SelectorNested<N>>
    implements PodsMetricStatusFluent.SelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this);
        }

        @Override
        public N and() {
            return (N)PodsMetricStatusFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }
}

