/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookClientConfig;
import io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookClientConfigBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookClientConfigFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookConversion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class WebhookConversionFluent<A extends WebhookConversionFluent<A>>
extends BaseFluent<A> {
    private WebhookClientConfigBuilder clientConfig;
    private List<String> conversionReviewVersions = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public WebhookConversionFluent() {
    }

    public WebhookConversionFluent(WebhookConversion instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(WebhookConversion instance) {
        WebhookConversion webhookConversion = instance = instance != null ? instance : new WebhookConversion();
        if (instance != null) {
            this.withClientConfig(instance.getClientConfig());
            this.withConversionReviewVersions(instance.getConversionReviewVersions());
            this.withClientConfig(instance.getClientConfig());
            this.withConversionReviewVersions(instance.getConversionReviewVersions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public WebhookClientConfig buildClientConfig() {
        return this.clientConfig != null ? this.clientConfig.build() : null;
    }

    public A withClientConfig(WebhookClientConfig clientConfig) {
        this._visitables.remove((Object)this.clientConfig);
        if (clientConfig != null) {
            this.clientConfig = new WebhookClientConfigBuilder(clientConfig);
            this._visitables.get((Object)"clientConfig").add(this.clientConfig);
        } else {
            this.clientConfig = null;
            this._visitables.get((Object)"clientConfig").remove((Object)this.clientConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasClientConfig() {
        return this.clientConfig != null;
    }

    public ClientConfigNested<A> withNewClientConfig() {
        return new ClientConfigNested(null);
    }

    public ClientConfigNested<A> withNewClientConfigLike(WebhookClientConfig item) {
        return new ClientConfigNested(item);
    }

    public ClientConfigNested<A> editClientConfig() {
        return this.withNewClientConfigLike(Optional.ofNullable(this.buildClientConfig()).orElse(null));
    }

    public ClientConfigNested<A> editOrNewClientConfig() {
        return this.withNewClientConfigLike(Optional.ofNullable(this.buildClientConfig()).orElse(new WebhookClientConfigBuilder().build()));
    }

    public ClientConfigNested<A> editOrNewClientConfigLike(WebhookClientConfig item) {
        return this.withNewClientConfigLike(Optional.ofNullable(this.buildClientConfig()).orElse(item));
    }

    public A addToConversionReviewVersions(int index, String item) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        this.conversionReviewVersions.add(index, item);
        return (A)((Object)this);
    }

    public A setToConversionReviewVersions(int index, String item) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        this.conversionReviewVersions.set(index, item);
        return (A)((Object)this);
    }

    public A addToConversionReviewVersions(String ... items) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.conversionReviewVersions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToConversionReviewVersions(Collection<String> items) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.conversionReviewVersions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromConversionReviewVersions(String ... items) {
        if (this.conversionReviewVersions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.conversionReviewVersions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConversionReviewVersions(Collection<String> items) {
        if (this.conversionReviewVersions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.conversionReviewVersions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getConversionReviewVersions() {
        return this.conversionReviewVersions;
    }

    public String getConversionReviewVersion(int index) {
        return this.conversionReviewVersions.get(index);
    }

    public String getFirstConversionReviewVersion() {
        return this.conversionReviewVersions.get(0);
    }

    public String getLastConversionReviewVersion() {
        return this.conversionReviewVersions.get(this.conversionReviewVersions.size() - 1);
    }

    public String getMatchingConversionReviewVersion(Predicate<String> predicate) {
        for (String item : this.conversionReviewVersions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingConversionReviewVersion(Predicate<String> predicate) {
        for (String item : this.conversionReviewVersions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConversionReviewVersions(List<String> conversionReviewVersions) {
        if (conversionReviewVersions != null) {
            this.conversionReviewVersions = new ArrayList<String>();
            for (String item : conversionReviewVersions) {
                this.addToConversionReviewVersions(item);
            }
        } else {
            this.conversionReviewVersions = null;
        }
        return (A)((Object)this);
    }

    public A withConversionReviewVersions(String ... conversionReviewVersions) {
        if (this.conversionReviewVersions != null) {
            this.conversionReviewVersions.clear();
            this._visitables.remove((Object)"conversionReviewVersions");
        }
        if (conversionReviewVersions != null) {
            for (String item : conversionReviewVersions) {
                this.addToConversionReviewVersions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConversionReviewVersions() {
        return this.conversionReviewVersions != null && !this.conversionReviewVersions.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebhookConversionFluent that = (WebhookConversionFluent)((Object)o);
        if (!Objects.equals((Object)this.clientConfig, (Object)that.clientConfig)) {
            return false;
        }
        if (!Objects.equals(this.conversionReviewVersions, that.conversionReviewVersions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientConfig, this.conversionReviewVersions, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientConfig != null) {
            sb.append("clientConfig:");
            sb.append((Object)((Object)this.clientConfig) + ",");
        }
        if (this.conversionReviewVersions != null && !this.conversionReviewVersions.isEmpty()) {
            sb.append("conversionReviewVersions:");
            sb.append(this.conversionReviewVersions + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ClientConfigNested<N>
    extends WebhookClientConfigFluent<ClientConfigNested<N>>
    implements Nested<N> {
        WebhookClientConfigBuilder builder;

        ClientConfigNested(WebhookClientConfig item) {
            this.builder = new WebhookClientConfigBuilder(this, item);
        }

        public N and() {
            return (N)WebhookConversionFluent.this.withClientConfig(this.builder.build());
        }

        public N endClientConfig() {
            return this.and();
        }
    }
}

