/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequest;
import io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionRequestFluentImpl;
import io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionResponse;
import io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionResponseBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionResponseFluentImpl;
import io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionReview;
import io.fabric8.kubernetes.api.model.apiextensions.v1.ConversionReviewFluent;
import java.util.Objects;

public class ConversionReviewFluentImpl<A extends ConversionReviewFluent<A>>
extends BaseFluent<A>
implements ConversionReviewFluent<A> {
    private String apiVersion;
    private String kind;
    private ConversionRequestBuilder request;
    private ConversionResponseBuilder response;

    public ConversionReviewFluentImpl() {
    }

    public ConversionReviewFluentImpl(ConversionReview instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withRequest(instance.getRequest());
        this.withResponse(instance.getResponse());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ConversionRequest getRequest() {
        return this.request != null ? this.request.build() : null;
    }

    @Override
    public ConversionRequest buildRequest() {
        return this.request != null ? this.request.build() : null;
    }

    @Override
    public A withRequest(ConversionRequest request) {
        this._visitables.get((Object)"request").remove(this.request);
        if (request != null) {
            this.request = new ConversionRequestBuilder(request);
            this._visitables.get((Object)"request").add(this.request);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRequest() {
        return this.request != null;
    }

    @Override
    public ConversionReviewFluent.RequestNested<A> withNewRequest() {
        return new RequestNestedImpl();
    }

    @Override
    public ConversionReviewFluent.RequestNested<A> withNewRequestLike(ConversionRequest item) {
        return new RequestNestedImpl(item);
    }

    @Override
    public ConversionReviewFluent.RequestNested<A> editRequest() {
        return this.withNewRequestLike(this.getRequest());
    }

    @Override
    public ConversionReviewFluent.RequestNested<A> editOrNewRequest() {
        return this.withNewRequestLike(this.getRequest() != null ? this.getRequest() : new ConversionRequestBuilder().build());
    }

    @Override
    public ConversionReviewFluent.RequestNested<A> editOrNewRequestLike(ConversionRequest item) {
        return this.withNewRequestLike(this.getRequest() != null ? this.getRequest() : item);
    }

    @Override
    @Deprecated
    public ConversionResponse getResponse() {
        return this.response != null ? this.response.build() : null;
    }

    @Override
    public ConversionResponse buildResponse() {
        return this.response != null ? this.response.build() : null;
    }

    @Override
    public A withResponse(ConversionResponse response) {
        this._visitables.get((Object)"response").remove(this.response);
        if (response != null) {
            this.response = new ConversionResponseBuilder(response);
            this._visitables.get((Object)"response").add(this.response);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResponse() {
        return this.response != null;
    }

    @Override
    public ConversionReviewFluent.ResponseNested<A> withNewResponse() {
        return new ResponseNestedImpl();
    }

    @Override
    public ConversionReviewFluent.ResponseNested<A> withNewResponseLike(ConversionResponse item) {
        return new ResponseNestedImpl(item);
    }

    @Override
    public ConversionReviewFluent.ResponseNested<A> editResponse() {
        return this.withNewResponseLike(this.getResponse());
    }

    @Override
    public ConversionReviewFluent.ResponseNested<A> editOrNewResponse() {
        return this.withNewResponseLike(this.getResponse() != null ? this.getResponse() : new ConversionResponseBuilder().build());
    }

    @Override
    public ConversionReviewFluent.ResponseNested<A> editOrNewResponseLike(ConversionResponse item) {
        return this.withNewResponseLike(this.getResponse() != null ? this.getResponse() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversionReviewFluentImpl that = (ConversionReviewFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.request != null ? !this.request.equals(that.request) : that.request != null) {
            return false;
        }
        return !(this.response != null ? !this.response.equals(that.response) : that.response != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.request, this.response, super.hashCode());
    }

    public class ResponseNestedImpl<N>
    extends ConversionResponseFluentImpl<ConversionReviewFluent.ResponseNested<N>>
    implements ConversionReviewFluent.ResponseNested<N>,
    Nested<N> {
        private final ConversionResponseBuilder builder;

        ResponseNestedImpl(ConversionResponse item) {
            this.builder = new ConversionResponseBuilder(this, item);
        }

        ResponseNestedImpl() {
            this.builder = new ConversionResponseBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConversionReviewFluentImpl.this.withResponse(this.builder.build());
        }

        @Override
        public N endResponse() {
            return this.and();
        }
    }

    public class RequestNestedImpl<N>
    extends ConversionRequestFluentImpl<ConversionReviewFluent.RequestNested<N>>
    implements ConversionReviewFluent.RequestNested<N>,
    Nested<N> {
        private final ConversionRequestBuilder builder;

        RequestNestedImpl(ConversionRequest item) {
            this.builder = new ConversionRequestBuilder(this, item);
        }

        RequestNestedImpl() {
            this.builder = new ConversionRequestBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConversionReviewFluentImpl.this.withRequest(this.builder.build());
        }

        @Override
        public N endRequest() {
            return this.and();
        }
    }
}

