/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.log4j.lookup;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.log4j.lookup.ClientBuilder;
import io.fabric8.kubernetes.log4j.lookup.ContainerUtil;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.lookup.AbstractLookup;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;

@Plugin(name="k8s", category="Lookup")
public class KubernetesLookup
extends AbstractLookup {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String HOSTNAME = "HOSTNAME";
    private static final String SPRING_ENVIRONMENT_KEY = "SpringEnvironment";
    private static final String ACCOUNT_NAME = "accountName";
    private static final String ANNOTATIONS = "annotations";
    private static final String CONTAINER_ID = "containerId";
    private static final String CONTAINER_NAME = "containerName";
    private static final String HOST = "host";
    private static final String HOST_IP = "hostIp";
    private static final String IMAGE_ID = "imageId";
    private static final String IMAGE_NAME = "imageName";
    private static final String LABELS = "labels";
    private static final String LABELS_PREFIX = "labels.";
    private static final String MASTER_URL = "masterUrl";
    private static final String NAMESPACE_ANNOTATIONS = "namespaceAnnotations";
    private static final String NAMESPACE_ID = "namespaceId";
    private static final String NAMESPACE_LABELS = "namespaceLabels";
    private static final String NAMESPACE_NAME = "namespaceName";
    private static final String POD_ID = "podId";
    private static final String POD_IP = "podIp";
    private static final String POD_NAME = "podName";
    private static KubernetesInfo kubernetesInfo;
    static Path cgroupPath;
    private static final ReadWriteLock LOCK;
    private static final Lock READ_LOCK;
    private static final Lock WRITE_LOCK;
    private static final boolean IS_SPRING_INCLUDED;
    private Pod pod;
    private Namespace namespace;
    private URL masterUrl;

    public KubernetesLookup() {
        this.pod = null;
        this.namespace = null;
        this.masterUrl = null;
        KubernetesLookup.initialize(this);
    }

    KubernetesLookup(Pod pod, Namespace namespace, URL masterUrl) {
        this.pod = pod;
        this.namespace = namespace;
        this.masterUrl = masterUrl;
        KubernetesLookup.initialize(this);
    }

    private static void initialize(KubernetesLookup lookup) {
        KubernetesInfo kubernetesInfo = KubernetesLookup.kubernetesInfo;
        if (kubernetesInfo == null || KubernetesLookup.isSpringStatusChanged(kubernetesInfo)) {
            WRITE_LOCK.lock();
            try {
                kubernetesInfo = KubernetesLookup.kubernetesInfo;
                if (kubernetesInfo == null || KubernetesLookup.isSpringStatusChanged(kubernetesInfo)) {
                    if (lookup.pod == null || lookup.namespace == null || lookup.masterUrl == null) {
                        KubernetesLookup.tryInitializeFields(lookup);
                    }
                    kubernetesInfo = new KubernetesInfo();
                    kubernetesInfo.isSpringActive = KubernetesLookup.isSpringActive();
                    kubernetesInfo.masterUrl = lookup.masterUrl;
                    if (lookup.namespace != null) {
                        KubernetesLookup.fillNamespaceData(lookup.namespace, kubernetesInfo);
                    }
                    if (lookup.pod != null) {
                        KubernetesLookup.fillPodData(lookup.pod, kubernetesInfo);
                    }
                    KubernetesLookup.kubernetesInfo = kubernetesInfo;
                }
            }
            finally {
                WRITE_LOCK.unlock();
            }
        }
    }

    private static boolean isSpringStatusChanged(KubernetesInfo kubernetesInfo) {
        return IS_SPRING_INCLUDED && KubernetesLookup.isSpringActive() != (kubernetesInfo != null && kubernetesInfo.isSpringActive);
    }

    private static boolean isSpringActive() {
        return IS_SPRING_INCLUDED && LogManager.getFactory() != null && LogManager.getFactory().hasContext(KubernetesLookup.class.getName(), null, false) && LogManager.getContext((boolean)false).getObject(SPRING_ENVIRONMENT_KEY) != null;
    }

    private static void tryInitializeFields(KubernetesLookup lookup) {
        KubernetesClient client = lookup.createClient();
        if (client != null) {
            if (lookup.pod == null) {
                lookup.pod = KubernetesLookup.getCurrentPod(client);
            }
            if (lookup.pod != null && lookup.namespace == null) {
                lookup.namespace = KubernetesLookup.getNamespace(client, lookup.pod);
            }
            if (lookup.masterUrl == null) {
                lookup.masterUrl = client.getMasterUrl();
            }
        } else {
            LOGGER.warn("Kubernetes is not available for access");
        }
    }

    protected KubernetesClient createClient() {
        return ClientBuilder.createClient();
    }

    private static Pod getCurrentPod(KubernetesClient kubernetesClient) {
        String hostName = KubernetesLookup.getHostName();
        try {
            if (hostName != null && !hostName.isEmpty()) {
                return (Pod)((PodResource)kubernetesClient.pods().withName(hostName)).get();
            }
        }
        catch (Exception e) {
            LOGGER.debug("Unable to locate pod with name {}.", (Object)hostName, (Object)e);
        }
        return null;
    }

    static String getHostName() {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostName != null && !"localhost".equals(hostName) ? hostName : System.getenv(HOSTNAME);
    }

    private static Namespace getNamespace(KubernetesClient client, Pod pod) {
        return (Namespace)((Resource)client.namespaces().withName(pod.getMetadata().getNamespace())).get();
    }

    private static void fillNamespaceData(Namespace namespace, KubernetesInfo kubernetesInfo) {
        ObjectMeta namespaceMetadata = namespace.getMetadata();
        if (namespaceMetadata != null) {
            kubernetesInfo.namespaceAnnotations = namespaceMetadata.getAnnotations();
            kubernetesInfo.namespaceId = namespaceMetadata.getUid();
            kubernetesInfo.namespaceLabels = namespaceMetadata.getLabels();
        }
    }

    private static void fillPodData(Pod pod, KubernetesInfo kubernetesInfo) {
        ObjectMeta podMetadata = pod.getMetadata();
        if (podMetadata != null) {
            kubernetesInfo.annotations = podMetadata.getAnnotations();
            kubernetesInfo.labels = podMetadata.getLabels();
            kubernetesInfo.namespace = podMetadata.getNamespace();
            kubernetesInfo.podId = podMetadata.getUid();
            kubernetesInfo.podName = podMetadata.getName();
        }
        KubernetesLookup.fillStatuses(pod, kubernetesInfo);
        String containerName = kubernetesInfo.containerName;
        PodSpec podSpec = pod.getSpec();
        if (podSpec != null) {
            kubernetesInfo.hostName = podSpec.getNodeName();
            kubernetesInfo.accountName = podSpec.getServiceAccountName();
            Container container = KubernetesLookup.getContainer(podSpec, containerName);
            if (container != null) {
                kubernetesInfo.containerName = container.getName();
                kubernetesInfo.imageName = container.getImage();
            }
        }
    }

    private static void fillStatuses(Pod pod, KubernetesInfo kubernetesInfo) {
        PodStatus podStatus = pod.getStatus();
        if (podStatus != null) {
            kubernetesInfo.hostIp = podStatus.getHostIP();
            kubernetesInfo.podIp = podStatus.getPodIP();
            ContainerStatus containerStatus = KubernetesLookup.getContainerStatus(podStatus);
            if (containerStatus != null) {
                kubernetesInfo.containerId = containerStatus.getContainerID();
                kubernetesInfo.imageId = containerStatus.getImageID();
                kubernetesInfo.containerName = containerStatus.getName();
            }
        }
    }

    private static ContainerStatus getContainerStatus(PodStatus podStatus) {
        List statuses = podStatus.getContainerStatuses();
        switch (statuses.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (ContainerStatus)statuses.get(0);
            }
        }
        String containerId = ContainerUtil.getContainerId(cgroupPath);
        return containerId != null ? (ContainerStatus)statuses.stream().filter(cs -> cs.getContainerID().contains(containerId)).findFirst().orElse(null) : null;
    }

    private static Container getContainer(PodSpec podSpec, String containerName) {
        List containers = podSpec.getContainers();
        switch (containers.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Container)containers.get(0);
            }
        }
        return containerName != null ? (Container)containers.stream().filter(c -> c.getName().equals(containerName)).findFirst().orElse(null) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lookup(LogEvent event, String key) {
        KubernetesInfo info;
        READ_LOCK.lock();
        try {
            info = kubernetesInfo;
        }
        finally {
            READ_LOCK.unlock();
        }
        if (key.startsWith(LABELS_PREFIX)) {
            return info.labels != null ? info.labels.get(key.substring(LABELS_PREFIX.length())) : null;
        }
        switch (key) {
            case "accountName": {
                return info.accountName;
            }
            case "annotations": {
                return info.annotations != null ? info.annotations.toString() : null;
            }
            case "containerId": {
                return info.containerId;
            }
            case "containerName": {
                return info.containerName;
            }
            case "host": {
                return info.hostName;
            }
            case "hostIp": {
                return info.hostIp;
            }
            case "labels": {
                return info.labels != null ? info.labels.toString() : null;
            }
            case "masterUrl": {
                return info.masterUrl != null ? info.masterUrl.toString() : null;
            }
            case "namespaceAnnotations": {
                return info.namespaceAnnotations != null ? info.namespaceAnnotations.toString() : null;
            }
            case "namespaceId": {
                return info.namespaceId;
            }
            case "namespaceLabels": {
                return info.namespaceLabels != null ? info.namespaceLabels.toString() : null;
            }
            case "namespaceName": {
                return info.namespace;
            }
            case "podId": {
                return info.podId;
            }
            case "podIp": {
                return info.podIp;
            }
            case "podName": {
                return info.podName;
            }
            case "imageId": {
                return info.imageId;
            }
            case "imageName": {
                return info.imageName;
            }
        }
        return null;
    }

    static void clear() {
        kubernetesInfo = null;
        cgroupPath = ContainerUtil.CGROUP_PATH;
    }

    static {
        cgroupPath = ContainerUtil.CGROUP_PATH;
        LOCK = new ReentrantReadWriteLock();
        READ_LOCK = LOCK.readLock();
        WRITE_LOCK = LOCK.writeLock();
        IS_SPRING_INCLUDED = LoaderUtil.isClassAvailable((String)"org.apache.logging.log4j.spring.cloud.config.client.SpringEnvironmentHolder") || LoaderUtil.isClassAvailable((String)"org.apache.logging.log4j.spring.boot.SpringEnvironmentHolder");
    }

    private static class KubernetesInfo {
        boolean isSpringActive;
        String accountName;
        Map<String, String> annotations;
        String containerId;
        String containerName;
        String hostName;
        String hostIp;
        String imageId;
        String imageName;
        Map<String, String> labels;
        URL masterUrl;
        String namespace;
        Map<String, String> namespaceAnnotations;
        String namespaceId;
        Map<String, String> namespaceLabels;
        String podId;
        String podIp;
        String podName;

        private KubernetesInfo() {
        }
    }
}

