/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.junit.jupiter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;

public interface BaseExtension {
    default public ExtensionContext.Namespace getNamespace(ExtensionContext context) {
        return ExtensionContext.Namespace.create((Object[])new Object[]{context.getRequiredTestClass()});
    }

    default public ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(this.getNamespace(context));
    }

    default public Field[] extractFields(ExtensionContext context, Class<?> clazz, Predicate<Field> ... predicates) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (context.getTestClass().isPresent()) {
            Class<Object> testClass = context.getTestClass().orElse(Object.class);
            fields.addAll(this.extractFields(testClass, clazz, predicates));
            for (Class<?> enclosingTestClass = testClass.getEnclosingClass(); enclosingTestClass != null; enclosingTestClass = enclosingTestClass.getEnclosingClass()) {
                fields.addAll(this.extractFields(enclosingTestClass, clazz, predicates));
            }
        }
        return fields.toArray(new Field[0]);
    }

    default public List<Field> extractFields(Class<?> testClass, Class<?> clazz, Predicate<Field> ... predicates) {
        ArrayList<Field> fields = new ArrayList<Field>();
        do {
            fields.addAll(BaseExtension.extractFieldsFromClass(testClass, clazz, predicates));
        } while ((testClass = testClass.getSuperclass()) != Object.class);
        return fields;
    }

    public static List<Field> extractFieldsFromClass(Class<?> classWhereFieldIs, Class<?> fieldType, Predicate<Field> ... predicates) {
        if (classWhereFieldIs != null && classWhereFieldIs != Object.class) {
            Stream<Field> fieldStream = Arrays.stream(classWhereFieldIs.getDeclaredFields()).filter(f -> fieldType.isAssignableFrom(f.getType()));
            for (Predicate<Field> p : predicates) {
                fieldStream = fieldStream.filter(p);
            }
            return fieldStream.collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    default public void setFieldValue(Field field, Object entity, Object value) throws IllegalAccessException {
        boolean isAccessible = field.isAccessible();
        field.setAccessible(true);
        field.set(entity, value);
        field.setAccessible(isAccessible);
    }

    default public <T extends Annotation> T findAnnotation(Class<?> clazz, Class<T> annotation) {
        T ret = null;
        if (clazz != null) {
            if (clazz.isAnnotationPresent(annotation)) {
                ret = clazz.getAnnotation(annotation);
            }
            if (ret == null && clazz.getSuperclass() != null) {
                ret = this.findAnnotation(clazz.getSuperclass(), annotation);
            }
            if (ret == null && clazz.getEnclosingClass() != null) {
                ret = this.findAnnotation(clazz.getEnclosingClass(), annotation);
            }
        }
        return ret;
    }
}

