/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.junit.jupiter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;

public interface BaseExtension {
    default public ExtensionContext.Namespace getNamespace(ExtensionContext context) {
        return ExtensionContext.Namespace.create((Object[])new Object[]{context.getRequiredTestClass()});
    }

    default public ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(this.getNamespace(context));
    }

    default public Field[] extractFields(ExtensionContext context, Class<?> clazz, Predicate<Field> ... predicates) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class testClass = context.getTestClass().orElse(Object.class);
        do {
            fields.addAll(BaseExtension.extractFields(testClass, clazz, predicates));
        } while ((testClass = testClass.getSuperclass()) != Object.class);
        return fields.toArray(new Field[0]);
    }

    public static List<Field> extractFields(Class<?> classWhereFieldIs, Class<?> fieldType, Predicate<Field> ... predicates) {
        if (classWhereFieldIs != null && classWhereFieldIs != Object.class) {
            Stream<Field> fieldStream = Arrays.stream(classWhereFieldIs.getDeclaredFields()).filter(f -> fieldType.isAssignableFrom(f.getType()));
            for (Predicate<Field> p : predicates) {
                fieldStream = fieldStream.filter(p);
            }
            return fieldStream.collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    default public void setFieldValue(Field field, Object entity, Object value) throws IllegalAccessException {
        boolean isAccessible = field.isAccessible();
        field.setAccessible(true);
        field.set(entity, value);
        field.setAccessible(isAccessible);
    }

    default public <T extends Annotation> T findAnnotation(Class<?> clazz, Class<T> annotation) {
        if (clazz != null) {
            if (clazz.isAnnotationPresent(annotation)) {
                return clazz.getAnnotation(annotation);
            }
            if (clazz.getSuperclass() != null) {
                return this.findAnnotation(clazz.getSuperclass(), annotation);
            }
        }
        return null;
    }
}

