/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.junit.jupiter;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.PropagationPolicyConfigurable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class KubernetesNamespacedTestExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback {
    private static final ExtensionContext.Namespace EXT_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{KubernetesNamespacedTestExtension.class});

    public void beforeAll(ExtensionContext context) throws Exception {
        KubernetesClient client = new KubernetesClientBuilder().build();
        KubernetesNamespacedTestExtension.getStore(context).put(Namespace.class, (Object)KubernetesNamespacedTestExtension.initNamespace(client));
        KubernetesNamespacedTestExtension.getStore(context).put(KubernetesClient.class, (Object)((NamespacedKubernetesClient)client.adapt(NamespacedKubernetesClient.class)).inNamespace(KubernetesNamespacedTestExtension.getNamespace(context).getMetadata().getName()));
        for (Field field : KubernetesNamespacedTestExtension.extractFields(context, KubernetesClient.class, f -> Modifier.isStatic(f.getModifiers()))) {
            KubernetesNamespacedTestExtension.setFieldValue(field, null, KubernetesNamespacedTestExtension.getClient(context).adapt(field.getType()));
        }
        for (Field field : KubernetesNamespacedTestExtension.extractFields(context, Namespace.class, f -> Modifier.isStatic(f.getModifiers()))) {
            KubernetesNamespacedTestExtension.setFieldValue(field, null, KubernetesNamespacedTestExtension.getNamespace(context));
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        for (Field field : KubernetesNamespacedTestExtension.extractFields(context, KubernetesClient.class, f -> !Modifier.isStatic(f.getModifiers()))) {
            KubernetesNamespacedTestExtension.setFieldValue(field, context.getRequiredTestInstance(), KubernetesNamespacedTestExtension.getClient(context).adapt(field.getType()));
        }
        for (Field field : KubernetesNamespacedTestExtension.extractFields(context, Namespace.class, f -> !Modifier.isStatic(f.getModifiers()))) {
            KubernetesNamespacedTestExtension.setFieldValue(field, context.getRequiredTestInstance(), KubernetesNamespacedTestExtension.getNamespace(context));
        }
    }

    public void afterAll(ExtensionContext context) {
        KubernetesClient client = KubernetesNamespacedTestExtension.getClient(context);
        ((PropagationPolicyConfigurable)client.resource((HasMetadata)KubernetesNamespacedTestExtension.getNamespace(context)).withGracePeriod(0L)).delete();
        client.close();
    }

    static KubernetesClient getClient(ExtensionContext context) {
        KubernetesClient client = (KubernetesClient)KubernetesNamespacedTestExtension.getStore(context).get(KubernetesClient.class, KubernetesClient.class);
        if (client == null) {
            throw new IllegalStateException("No KubernetesClient found");
        }
        return client;
    }

    private static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(EXT_NAMESPACE);
    }

    private static Namespace initNamespace(KubernetesClient client) {
        Namespace namespace = (Namespace)client.resource((HasMetadata)((NamespaceBuilder)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(UUID.randomUUID().toString())).addToLabels("app", "fabric8-kubernetes-client-test")).endMetadata()).build()).create();
        int major = Integer.parseInt(client.getKubernetesVersion().getMajor().replaceAll("\\D+", ""));
        int minor = Integer.parseInt(client.getKubernetesVersion().getMinor().replaceAll("\\D+", ""));
        if (major < 1 || major == 1 && minor < 24) {
            List secrets = ((ServiceAccount)((Resource)((NonNamespaceOperation)client.serviceAccounts().inNamespace(namespace.getMetadata().getName())).withName("default")).waitUntilCondition(sa -> sa != null && sa.getSecrets() != null && sa.getSecrets().stream().anyMatch(s -> s.getName().matches("default-token.+")), 5L, TimeUnit.SECONDS)).getSecrets();
            for (ObjectReference secret : secrets) {
                ((Resource)((NonNamespaceOperation)client.secrets().inNamespace(namespace.getMetadata().getName())).withName(secret.getName())).waitUntilCondition(Objects::nonNull, 5L, TimeUnit.SECONDS);
            }
        }
        return namespace;
    }

    private static Namespace getNamespace(ExtensionContext context) {
        Namespace namespace = (Namespace)KubernetesNamespacedTestExtension.getStore(context).get(Namespace.class, Namespace.class);
        if (namespace == null) {
            throw new IllegalStateException("No Kubernetes Namespace found");
        }
        return namespace;
    }

    private static Field[] extractFields(ExtensionContext context, Class<?> clazz, Predicate<Field> ... predicates) {
        Class testClass = context.getTestClass().orElse(null);
        if (testClass != null) {
            Stream<Field> fieldStream = Arrays.stream(testClass.getDeclaredFields()).filter(f -> clazz.isAssignableFrom(f.getType()));
            for (Predicate<Field> p : predicates) {
                fieldStream = fieldStream.filter(p);
            }
            return (Field[])fieldStream.toArray(Field[]::new);
        }
        return new Field[0];
    }

    private static void setFieldValue(Field field, Object entity, Object value) throws IllegalAccessException {
        boolean isAccessible = field.isAccessible();
        field.setAccessible(true);
        field.set(entity, value);
        field.setAccessible(isAccessible);
    }
}

