/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.jetty;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.BufferUtil;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketResponse;
import io.fabric8.kubernetes.client.http.WebSocketUpgradeResponse;
import io.fabric8.kubernetes.client.utils.Utils;
import java.net.ProtocolException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.exceptions.CloseException;
import org.eclipse.jetty.websocket.api.exceptions.UpgradeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocket
implements WebSocket,
WebSocketListener {
    private static final Logger LOG = LoggerFactory.getLogger(JettyWebSocket.class);
    private final WebSocket.Listener listener;
    private final AtomicLong sendQueue;
    private final Lock lock;
    private final Condition backPressure;
    private final CompletableFuture<Void> terminated = new CompletableFuture();
    private final AtomicBoolean outputClosed = new AtomicBoolean();
    private boolean moreMessages;
    private volatile Session webSocketSession;

    public JettyWebSocket(WebSocket.Listener listener) {
        this.listener = listener;
        this.sendQueue = new AtomicLong();
        this.lock = new ReentrantLock();
        this.backPressure = this.lock.newCondition();
        this.moreMessages = true;
    }

    public boolean send(ByteBuffer buffer) {
        if (this.outputClosed.get() || this.terminated.isDone() || !this.webSocketSession.isOpen()) {
            return false;
        }
        buffer = BufferUtil.copy((ByteBuffer)buffer);
        final int size = buffer.remaining();
        this.sendQueue.addAndGet(size);
        this.webSocketSession.getRemote().sendBytes(buffer, new WriteCallback(){

            public void writeFailed(Throwable x) {
                JettyWebSocket.this.sendQueue.addAndGet(-size);
                if (JettyWebSocket.this.webSocketSession.isOpen()) {
                    LOG.warn("Queued write did not succeed", x);
                }
                JettyWebSocket.this.webSocketSession.disconnect();
            }

            public void writeSuccess() {
                JettyWebSocket.this.sendQueue.addAndGet(-size);
            }
        });
        return true;
    }

    public boolean sendClose(int code, String reason) {
        if (!this.outputClosed.compareAndSet(false, true) || !this.webSocketSession.isOpen()) {
            return false;
        }
        this.webSocketSession.close(code, reason, new WriteCallback(){

            public void writeFailed(Throwable x) {
                LOG.warn("Queued close did not succeed", x);
                JettyWebSocket.this.webSocketSession.disconnect();
            }

            public void writeSuccess() {
                CompletableFuture future = Utils.schedule(Runnable::run, () -> ((Session)JettyWebSocket.this.webSocketSession).disconnect(), (long)1L, (TimeUnit)TimeUnit.MINUTES);
                JettyWebSocket.this.terminated.whenComplete((v, ignored) -> future.cancel(true));
            }
        });
        return true;
    }

    public long queueSize() {
        return this.sendQueue.get();
    }

    public void request() {
        try {
            this.lock.lock();
            this.moreMessages = true;
            this.backPressure.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        this.backPressure();
        ByteBuffer buffer = ByteBuffer.allocate(len);
        buffer.put(payload, offset, len).rewind();
        this.listener.onMessage((WebSocket)this, buffer.asReadOnlyBuffer());
    }

    public void onWebSocketText(String message) {
        this.backPressure();
        this.listener.onMessage((WebSocket)this, message);
    }

    public void onWebSocketClose(int statusCode, String reason) {
        this.terminated.complete(null);
        this.listener.onClose((WebSocket)this, statusCode, reason);
    }

    public void onWebSocketConnect(Session session) {
        this.webSocketSession = session;
        this.listener.onOpen((WebSocket)this);
    }

    public void onWebSocketError(Throwable cause) {
        if (cause instanceof ClosedChannelException && (this.outputClosed.get() || !this.terminated.complete(null))) {
            return;
        }
        if (cause instanceof CloseException) {
            cause = new ProtocolException().initCause(cause);
        }
        this.listener.onError((WebSocket)this, cause);
    }

    private void backPressure() {
        try {
            this.lock.lock();
            while (!this.moreMessages) {
                if (this.backPressure.await(30L, TimeUnit.SECONDS)) continue;
                throw new KubernetesClientException("Jetty HttpClient thread is waiting too long for the consumption of previous websocket message");
            }
            this.moreMessages = false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    static WebSocketResponse toWebSocketResponse(HttpRequest httpRequest, UpgradeException ex) {
        WebSocketUpgradeResponse webSocketUpgradeResponse = new WebSocketUpgradeResponse(httpRequest, ex.getResponseStatusCode());
        return new WebSocketResponse(webSocketUpgradeResponse, (Throwable)ex);
    }

    static WebSocketResponse toWebSocketResponse(HttpRequest httpRequest, WebSocket ws, Session session) {
        UpgradeResponse jettyUpgradeResponse = session.getUpgradeResponse();
        WebSocketUpgradeResponse fabric8UpgradeResponse = new WebSocketUpgradeResponse(httpRequest, jettyUpgradeResponse.getStatusCode(), jettyUpgradeResponse.getHeaders());
        return new WebSocketResponse(fabric8UpgradeResponse, ws);
    }
}

