/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.jetty;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.internal.SSLUtils;
import io.fabric8.kubernetes.client.jetty.DerivedJettyHttpClientBuilder;
import io.fabric8.kubernetes.client.jetty.JettyHttpClient;
import io.fabric8.kubernetes.client.jetty.JettyHttpClientFactory;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.dynamic.HttpClientTransportDynamic;
import org.eclipse.jetty.client.http.HttpClientConnectionFactory;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.http.ClientConnectionFactoryOverHTTP2;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class JettyHttpClientBuilder
extends DerivedJettyHttpClientBuilder<JettyHttpClientBuilder>
implements HttpClient.Builder {
    private Duration connectTimeout;
    private SSLContext sslContext;
    private boolean followAllRedirects;
    private Origin.Address proxyAddress;
    private String proxyAuthorization;
    private TlsVersion[] tlsVersions;
    private boolean preferHttp11 = true;
    private HttpClient sharedHttpClient;
    private WebSocketClient sharedWebSocketClient;

    public JettyHttpClientBuilder(JettyHttpClientFactory factory) {
        super(factory);
    }

    public JettyHttpClient build() {
        if (this.sharedHttpClient != null) {
            return new JettyHttpClient(this, this.sharedHttpClient, this.sharedWebSocketClient, this.interceptors.values(), this.factory);
        }
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
        if (this.sslContext != null) {
            sslContextFactory.setSslContext(this.sslContext);
        }
        if (this.tlsVersions != null && this.tlsVersions.length > 0) {
            sslContextFactory.setIncludeProtocols((String[])Stream.of(this.tlsVersions).map(TlsVersion::javaName).toArray(String[]::new));
        }
        this.sharedHttpClient = new HttpClient(JettyHttpClientBuilder.newTransport(sslContextFactory, this.preferHttp11));
        this.sharedWebSocketClient = new WebSocketClient(new HttpClient(JettyHttpClientBuilder.newTransport(sslContextFactory, this.preferHttp11)));
        this.sharedWebSocketClient.setIdleTimeout(Duration.ZERO);
        if (this.connectTimeout != null) {
            this.sharedHttpClient.setConnectTimeout(this.connectTimeout.toMillis());
            this.sharedWebSocketClient.setConnectTimeout(this.connectTimeout.toMillis());
        }
        this.sharedHttpClient.setFollowRedirects(this.followAllRedirects);
        if (this.proxyAddress != null) {
            this.sharedHttpClient.getProxyConfiguration().getProxies().add(new HttpProxy(this.proxyAddress, false));
        }
        if (this.proxyAddress != null && this.proxyAuthorization != null) {
            this.sharedHttpClient.getRequestListeners().add(new Request.Listener.Adapter(){

                public void onBegin(Request request) {
                    request.headers(h -> h.put("Proxy-Authorization", JettyHttpClientBuilder.this.proxyAuthorization));
                }
            });
        }
        return new JettyHttpClient(this, this.sharedHttpClient, this.sharedWebSocketClient, this.interceptors.values(), this.factory);
    }

    public JettyHttpClientBuilder connectTimeout(long connectTimeout, TimeUnit unit) {
        this.connectTimeout = Duration.ofNanos(unit.toNanos(connectTimeout));
        return this;
    }

    public JettyHttpClientBuilder sslContext(KeyManager[] keyManagers, TrustManager[] trustManagers) {
        this.sslContext = SSLUtils.sslContext((KeyManager[])keyManagers, (TrustManager[])trustManagers);
        return this;
    }

    public JettyHttpClientBuilder followAllRedirects() {
        this.followAllRedirects = true;
        return this;
    }

    public JettyHttpClientBuilder proxyAddress(InetSocketAddress proxyAddress) {
        this.proxyAddress = proxyAddress == null ? null : new Origin.Address(proxyAddress.getHostString(), proxyAddress.getPort());
        return this;
    }

    public JettyHttpClientBuilder proxyAuthorization(String credentials) {
        this.proxyAuthorization = credentials;
        return this;
    }

    public JettyHttpClientBuilder tlsVersions(TlsVersion ... tlsVersions) {
        this.tlsVersions = tlsVersions;
        return this;
    }

    public JettyHttpClientBuilder preferHttp11() {
        this.preferHttp11 = true;
        return this;
    }

    public HttpClient.Builder copy() {
        JettyHttpClientBuilder ret = new JettyHttpClientBuilder(this.factory);
        ret.sharedHttpClient = this.sharedHttpClient;
        ret.sharedWebSocketClient = this.sharedWebSocketClient;
        ret.readTimeout = this.readTimeout;
        ret.writeTimeout = this.writeTimeout;
        ret.interceptors.putAll(this.interceptors);
        ret.connectTimeout = this.connectTimeout;
        ret.sslContext = this.sslContext;
        ret.followAllRedirects = this.followAllRedirects;
        ret.proxyAddress = this.proxyAddress;
        ret.proxyAuthorization = this.proxyAuthorization;
        ret.tlsVersions = this.tlsVersions;
        ret.preferHttp11 = this.preferHttp11;
        return ret;
    }

    private static HttpClientTransport newTransport(SslContextFactory.Client sslContextFactory, boolean preferHttp11) {
        HttpClientTransportOverHTTP transport;
        ClientConnector clientConnector = new ClientConnector();
        clientConnector.setSslContextFactory(sslContextFactory);
        if (preferHttp11) {
            transport = new HttpClientTransportOverHTTP(clientConnector);
        } else {
            ClientConnectionFactoryOverHTTP2.HTTP2 http2 = new ClientConnectionFactoryOverHTTP2.HTTP2(new HTTP2Client(clientConnector));
            transport = new HttpClientTransportDynamic(clientConnector, new ClientConnectionFactory.Info[]{http2, HttpClientConnectionFactory.HTTP11});
        }
        return transport;
    }
}

