/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.jetty;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.jetty.JettyHttpClientFactory;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class DerivedJettyHttpClientBuilder<T extends HttpClient.DerivedClientBuilder>
implements HttpClient.DerivedClientBuilder {
    final JettyHttpClientFactory factory;
    Duration readTimeout = Duration.ZERO;
    Duration writeTimeout = Duration.ZERO;
    final Map<String, Interceptor> interceptors;

    DerivedJettyHttpClientBuilder(JettyHttpClientFactory factory) {
        this.factory = factory;
        this.interceptors = new LinkedHashMap<String, Interceptor>();
    }

    public final T readTimeout(long readTimeout, TimeUnit unit) {
        this.readTimeout = Duration.ofNanos(unit.toNanos(readTimeout));
        return (T)this;
    }

    public T writeTimeout(long writeTimeout, TimeUnit unit) {
        this.writeTimeout = Duration.ofNanos(unit.toNanos(writeTimeout));
        return (T)this;
    }

    public T forStreaming() {
        return (T)this;
    }

    public T authenticatorNone() {
        return (T)this;
    }

    public T addOrReplaceInterceptor(String name, Interceptor interceptor) {
        this.interceptors.put(name, interceptor);
        return (T)this;
    }
}

