/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.generator.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.generator.annotation.KubernetesProvider;
import io.fabric8.kubernetes.generator.processor.AbstractKubernetesAnnotationProcessor;
import io.fabric8.kubernetes.generator.processor.CompilationTaskFactory;
import io.fabric8.utils.Strings;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaCompiler;

@SupportedAnnotationTypes(value={"io.fabric8.kubernetes.generator.annotation.KubernetesProvider"})
public class KubernetesProviderProcessor
extends AbstractKubernetesAnnotationProcessor {
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        KubernetesResource kubernetesResource;
        void var7_11;
        StringWriter writer;
        LinkedHashSet<HasMetadata> provided;
        block14: {
            provided = new LinkedHashSet<HasMetadata>();
            CompilationTaskFactory compilationTaskFactory = new CompilationTaskFactory(this.processingEnv);
            HashSet<TypeElement> providers = new HashSet<TypeElement>();
            for (Element element : roundEnv.getElementsAnnotatedWith(KubernetesProvider.class)) {
                providers.add(this.getClassElement(element));
            }
            if (providers.isEmpty()) {
                return true;
            }
            writer = new StringWriter();
            try {
                JavaCompiler.CompilationTask compilationTask = compilationTaskFactory.create(providers, writer);
                if (((Boolean)compilationTask.call()).booleanValue()) break block14;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to compile provider classes. See output below.");
                boolean bl = false;
                return bl;
            }
            catch (Exception exception) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error to compile provider classes, due to: " + exception.getMessage() + ". See output below.");
                boolean bl = false;
                return bl;
            }
            finally {
                String output = writer.toString();
                if (Strings.isNullOrBlank((String)output)) {
                    output = "success";
                }
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Fabric8 model generator compiler output:" + output);
            }
        }
        String string = writer.toString();
        if (Strings.isNullOrBlank((String)string)) {
            String string2 = "success";
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Fabric8 model generator compiler output:" + (String)var7_11);
        for (Element element : roundEnv.getElementsAnnotatedWith(KubernetesProvider.class)) {
            try {
                Object obj;
                if (!(element instanceof ExecutableElement)) continue;
                KubernetesProvider provider = element.getAnnotation(KubernetesProvider.class);
                ExecutableElement methodElement = (ExecutableElement)element;
                String methodName = methodElement.getSimpleName().toString();
                TypeElement classElement = this.getClassElement(element);
                Class<?> cls = Class.forName(classElement.getQualifiedName().toString());
                Object instance = cls.newInstance();
                Method providerMethod = instance.getClass().getDeclaredMethod(methodName, new Class[0]);
                if (providerMethod == null || !((obj = providerMethod.invoke(instance, new Object[0])) instanceof HasMetadata)) continue;
                provided.add((HasMetadata)obj);
            }
            catch (Exception ex) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error creating Kubernetes configuration.");
            }
        }
        Object var7_14 = null;
        try {
            kubernetesResource = (KubernetesResource)KubernetesHelper.combineJson((Object[])new Object[]{provided});
        }
        catch (Exception exception) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to combine provider items");
            return false;
        }
        this.generateJson(kubernetesResource);
        return true;
    }

    private KubernetesList createList(Iterable<HasMetadata> objects) {
        StringBuilder sb = new StringBuilder();
        ArrayList<HasMetadata> allItems = new ArrayList<HasMetadata>();
        boolean first = true;
        for (HasMetadata obj : objects) {
            if (first) {
                first = false;
            } else {
                sb.append("-");
            }
            sb.append(KubernetesHelper.getName((HasMetadata)obj));
            allItems.add(obj);
        }
        return ((KubernetesListBuilder)new KubernetesListBuilder().withItems(allItems)).build();
    }
}

