/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.generator.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.processing.AbstractProcessor;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public abstract class AbstractKubernetesAnnotationProcessor
extends AbstractProcessor {
    private static final String KUBERNETES_JSON = "kubernetes.json";
    private static final String KUBERNETES_YAML = "kubernetes.yml";
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    KubernetesResource readJson(String fileName) {
        try {
            FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", fileName == null ? KUBERNETES_JSON : fileName);
            try (Reader reader = fileObject.openReader(false);){
                KubernetesResource kubernetesResource = (KubernetesResource)MAPPER.readValue(reader, KubernetesResource.class);
                return kubernetesResource;
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, fileName + " JSON not found.");
            return null;
        }
    }

    void generateJson(KubernetesResource resource) {
        this.generateJson(KUBERNETES_JSON, resource);
    }

    void generateJson(String fileName, KubernetesResource resource) {
        try {
            FileObject fileObject = this.getFileObject(fileName);
            try (Writer writer = fileObject.openWriter();){
                MAPPER.writeValue(writer, (Object)resource);
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error generating json " + fileName);
        }
    }

    void generateYaml(KubernetesResource resource) {
        this.generateYaml(KUBERNETES_YAML, resource);
    }

    void generateYaml(String fileName, KubernetesResource resource) {
        try {
            FileObject fileObject = this.getFileObject(fileName);
            KubernetesHelper.saveYaml((Object)resource, (FileObject)fileObject);
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error generating json " + fileName);
        }
    }

    private FileObject getFileObject(String fileName) throws IOException {
        FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", fileName);
        Path path = Paths.get(fileObject.toUri());
        File file = path.toFile();
        if (file.exists() && !file.delete()) {
            throw new IOException("Failed to delete old kubernetes json file: " + fileName);
        }
        fileObject = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", fileName, new Element[0]);
        return fileObject;
    }

    TypeElement getClassElement(Element element) {
        if (element instanceof PackageElement) {
            throw new IllegalArgumentException("Invalid element. A package element can't be used to retrieve a class element");
        }
        if (element instanceof TypeElement && element.getEnclosingElement() instanceof PackageElement) {
            return (TypeElement)element;
        }
        return this.getClassElement(element.getEnclosingElement());
    }

    PackageElement getPackageElement(Element element) {
        if (element instanceof PackageElement) {
            return (PackageElement)element;
        }
        return this.getPackageElement(element.getEnclosingElement());
    }

    static enum FileExtension {
        JSON,
        YAML,
        UNDEFINED;


        public static FileExtension determineExtension(String extension) {
            if ("json".equals(extension)) {
                return JSON;
            }
            if ("yaml".equals(extension) || "yml".equals(extension)) {
                return YAML;
            }
            return UNDEFINED;
        }
    }
}

