/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.generator.processor;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class CompilationTaskFactory {
    private static final String FILE_URL_PREFIX = "file:";
    private static final String DISABLE_ANNOTATION_PROCESSORS_OPT = "-proc:none";
    private static final String CLASSPATH_OPT = "-classpath";
    private static final String FILE_MANAGER_FIELD_NAME = "fileManager";
    private final DiagnosticListener<JavaFileObject> diagnosticListener = new DiagnosticCollector<JavaFileObject>();
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final ProcessingEnvironment processingEnvironment;
    private final JavaFileManager fileManager;

    public CompilationTaskFactory(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
        this.fileManager = CompilationTaskFactory.createFileManager(processingEnvironment);
    }

    static JavaFileManager createFileManager(ProcessingEnvironment processingEnvironment) {
        Filer filer = processingEnvironment.getFiler();
        try {
            Field field = filer.getClass().getDeclaredField(FILE_MANAGER_FIELD_NAME);
            field.setAccessible(true);
            return (JavaFileManager)field.get(filer);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public JavaCompiler.CompilationTask create(Iterable<TypeElement> elements) throws IOException {
        LinkedHashSet<String> options = new LinkedHashSet<String>();
        LinkedHashSet<JavaFileObject> javaFileObjects = new LinkedHashSet<JavaFileObject>();
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            String classPath = CompilationTaskFactory.createClassPath(((URLClassLoader)classLoader).getURLs());
            options.add(DISABLE_ANNOTATION_PROCESSORS_OPT);
            options.add(CLASSPATH_OPT);
            options.add(classPath);
        }
        for (TypeElement element : elements) {
            javaFileObjects.add(this.fileManager.getJavaFileForInput(StandardLocation.SOURCE_PATH, element.getQualifiedName().toString(), JavaFileObject.Kind.SOURCE));
        }
        return this.compiler.getTask(null, this.fileManager, this.diagnosticListener, options, new ArrayList<String>(), javaFileObjects);
    }

    private static String createClassPath(URL[] urls) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (URL url : urls) {
            if (first) {
                first = false;
            } else {
                sb.append(File.pathSeparator);
            }
            sb.append(url.toExternalForm().replaceFirst(FILE_URL_PREFIX, ""));
        }
        return sb.toString();
    }
}

