/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.generator.processor;

import io.fabric8.common.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.generator.annotation.KubernetesModelProcessor;
import io.fabric8.kubernetes.generator.processor.AbstractKubernetesAnnotationProcessor;
import io.fabric8.kubernetes.generator.processor.CompilationTaskFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.JavaCompiler;

@SupportedAnnotationTypes(value={"io.fabric8.kubernetes.generator.annotation.KubernetesModelProcessor"})
public class KubernetesModelProcessorProcessor
extends AbstractKubernetesAnnotationProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        LinkedHashSet provided = new LinkedHashSet();
        CompilationTaskFactory compilationTaskFactory = new CompilationTaskFactory(this.processingEnv);
        HashSet<TypeElement> processors = new HashSet<TypeElement>();
        for (Element element : roundEnv.getElementsAnnotatedWith(KubernetesModelProcessor.class)) {
            processors.add(this.getClassElement(element));
        }
        if (processors.isEmpty()) {
            return true;
        }
        try {
            JavaCompiler.CompilationTask compileTask = compilationTaskFactory.create(processors);
            if (!((Boolean)compileTask.call()).booleanValue()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to compile provider classes");
                return false;
            }
        }
        catch (Exception e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to compile provider classes");
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(KubernetesModelProcessor.class)) {
            KubernetesListBuilder builder = new KubernetesListBuilder(this.readJson());
            try {
                if (element instanceof TypeElement) {
                    KubernetesModelProcessor processor = element.getAnnotation(KubernetesModelProcessor.class);
                    for (ExecutableElement methodElement : ElementFilter.methodsIn(element.getEnclosedElements())) {
                        TypeElement classElement = this.getClassElement(element);
                        Class<?> cls = Class.forName(classElement.getQualifiedName().toString());
                        final Object instance = cls.newInstance();
                        final String methodName = methodElement.getSimpleName().toString();
                        builder.accept(new Visitor(){

                            public void visit(Object o) {
                                for (Method m : KubernetesModelProcessorProcessor.this.findMethods(instance, methodName, o.getClass())) {
                                    try {
                                        m.invoke(instance, o);
                                    }
                                    catch (IllegalAccessException e) {
                                        KubernetesModelProcessorProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error invoking visitor method:" + m.getName() + " on:" + instance + "with argument:" + o);
                                    }
                                    catch (InvocationTargetException e) {
                                        KubernetesModelProcessorProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error invoking visitor method:" + m.getName() + " on:" + instance + "with argument:" + o);
                                    }
                                }
                            }
                        });
                    }
                }
                KubernetesList list = builder.build();
                this.generateJson(list);
            }
            catch (Exception ex) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error creating Kubernetes configuration:" + ex.getMessage());
            }
        }
        return true;
    }

    private Set<Method> findMethods(Object instance, String methodName, Class argumentType) {
        LinkedHashSet<Method> result = new LinkedHashSet<Method>();
        for (Method m : instance.getClass().getDeclaredMethods()) {
            if (!m.getName().equals(methodName) || m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].isAssignableFrom(argumentType)) continue;
            result.add(m);
        }
        return result;
    }
}

