/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortForwardExample {
    private static final Logger logger = LoggerFactory.getLogger(PortForwardExample.class);

    public static void main(String[] args) {
        ConfigBuilder configBuilder = new ConfigBuilder();
        if (args.length > 0) {
            configBuilder.withMasterUrl(args[0]);
            logger.info("Using master with URL: {}", (Object)args[0]);
        }
        try (KubernetesClient client = new KubernetesClientBuilder().withConfig(configBuilder.build()).build();){
            String namespace = "default";
            logger.info("Using namespace: {}", (Object)namespace);
            Pod pod = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).load(PortForwardExample.class.getResourceAsStream("/portforward-example-pod.yml"))).item();
            String podName = pod.getMetadata().getName();
            ((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).resource((Object)pod)).create();
            logger.info("Pod {} created", (Object)podName);
            int containerPort = ((ContainerPort)((Container)pod.getSpec().getContainers().get(0)).getPorts().get(0)).getContainerPort();
            ((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(podName)).waitUntilReady(10L, TimeUnit.SECONDS);
            InetAddress inetAddress = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
            LocalPortForward portForward = ((PodResource)((NonNamespaceOperation)client.pods().inNamespace("default")).withName("testpod")).portForward(containerPort, inetAddress, 8080);
            logger.info("Port forwarded for 60 seconds at http://127.0.0.1:{}", (Object)portForward.getLocalPort());
            logger.info("Checking forwarded port:-");
            ResponseBody responseBody = new OkHttpClient().newCall(new Request.Builder().get().url("http://127.0.0.1:" + portForward.getLocalPort()).build()).execute().body();
            logger.info("Response: \n{}", (Object)(responseBody != null ? responseBody.string() : "[Empty Body]"));
            Thread.sleep(60000L);
            logger.info("Closing forwarded port");
            portForward.close();
        }
        catch (Exception e) {
            logger.error("Exception occurred: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

