/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.DefaultKubernetesResourceList;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersionFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceValidationFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsBuilder;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.io.Serializable;

public class CustomResourceV1Example {
    public static void main(String ... args) {
        try (KubernetesClient kc = new KubernetesClientBuilder().build();){
            CustomResourceDefinition crd = ((CustomResourceDefinitionBuilder)((CustomResourceDefinitionFluent.SpecNested)((CustomResourceDefinitionSpecFluent.VersionsNested)((CustomResourceDefinitionVersionFluent.SchemaNested)((CustomResourceValidationFluent.OpenAPIV3SchemaNested)((CustomResourceValidationFluent.OpenAPIV3SchemaNested)((CustomResourceValidationFluent.OpenAPIV3SchemaNested)((CustomResourceValidationFluent.OpenAPIV3SchemaNested)CustomResourceDefinitionContext.v1CRDFromCustomResourceType(Show.class).editSpec().editVersion(0).withNewSchema().withNewOpenAPIV3Schema().withTitle("Shows")).withType("object")).addToRequired(new String[]{"spec"})).addToProperties("spec", ((JSONSchemaPropsBuilder)((JSONSchemaPropsBuilder)((JSONSchemaPropsBuilder)new JSONSchemaPropsBuilder().withType("object")).addToProperties("name", ((JSONSchemaPropsBuilder)new JSONSchemaPropsBuilder().withType("string")).build())).addToProperties("score", ((JSONSchemaPropsBuilder)new JSONSchemaPropsBuilder().withType("number")).build())).build())).endOpenAPIV3Schema()).endSchema()).endVersion()).endSpec()).build();
            ((Resource)kc.apiextensions().v1().customResourceDefinitions().resource((Object)crd)).createOrReplace();
            System.out.println("Created custom shows.example.com Kubernetes API");
            NonNamespaceOperation shows = (NonNamespaceOperation)kc.resources(Show.class, ShowList.class).inNamespace("default");
            shows.list();
            ((Resource)shows.resource((Object)new Show("breaking-bad", new ShowSpec("Breaking Bad", 10)))).createOrReplace();
            ((Resource)shows.resource((Object)new Show("better-call-saul", new ShowSpec("Better call Saul", 8)))).createOrReplace();
            ((Resource)shows.resource((Object)new Show("the-wire", new ShowSpec("The Wire", 10)))).createOrReplace();
            System.out.println("Added three shows");
            ((ShowList)((Object)shows.list())).getItems().forEach(s -> System.out.printf(" - %s%n", ((ShowSpec)s.getSpec()).name));
            Show theWire = (Show)((Object)((Resource)shows.withName("the-wire")).get());
            System.out.printf("The Wire Score is: %s%n", ((ShowSpec)theWire.getSpec()).score);
        }
    }

    public static final class ShowSpec
    implements Serializable {
        private static final long serialVersionUID = -1548881019086449848L;
        private String name;
        private Number score;

        public ShowSpec() {
        }

        public ShowSpec(String name, int score) {
            this.name = name;
            this.score = score;
        }

        public String getName() {
            return this.name;
        }

        public Number getScore() {
            return this.score;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setScore(Number score) {
            this.score = score;
        }
    }

    public static final class ShowList
    extends DefaultKubernetesResourceList<Show> {
    }

    @Group(value="example.com")
    @Version(value="v1")
    public static final class Show
    extends CustomResource<ShowSpec, Void>
    implements Namespaced {
        public Show() {
        }

        public Show(String metaName, ShowSpec spec) {
            this.setMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withName(metaName)).build());
            this.setSpec(spec);
        }
    }
}

