/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.NodeSelectorFluent;
import io.fabric8.kubernetes.api.model.NodeSelectorRequirementBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.VolumeNodeAffinityFluent;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentVolumeExample {
    private static final Logger logger = LoggerFactory.getLogger(PersistentVolumeExample.class);

    public static void main(String[] args) {
        ConfigBuilder configBuilder = new ConfigBuilder();
        if (args.length > 0) {
            configBuilder.withMasterUrl(args[0]);
            logger.info("Using master with URL: {}", (Object)args[0]);
        }
        try (KubernetesClient client = new KubernetesClientBuilder().withConfig(configBuilder.build()).build();){
            logger.info("Creating persistent volume object");
            PersistentVolume pv = ((PersistentVolumeBuilder)((PersistentVolumeFluent.SpecNested)((PersistentVolumeSpecFluent.NodeAffinityNested)((VolumeNodeAffinityFluent.RequiredNested)((NodeSelectorFluent.NodeSelectorTermsNested)((PersistentVolumeFluent.SpecNested)((PersistentVolumeSpecFluent.LocalNested)((PersistentVolumeFluent.SpecNested)((PersistentVolumeFluent.SpecNested)((PersistentVolumeFluent.SpecNested)((PersistentVolumeFluent.SpecNested)((PersistentVolumeBuilder)((PersistentVolumeFluent.MetadataNested)new PersistentVolumeBuilder().withNewMetadata().withName("example-local-pv")).endMetadata()).withNewSpec().addToCapacity(Collections.singletonMap("storage", new Quantity("500Gi")))).withAccessModes(new String[]{"ReadWriteOnce"})).withPersistentVolumeReclaimPolicy("Retain")).withStorageClassName("local-storage")).withNewLocal().withPath("/mnt/disks/vol1")).endLocal()).withNewNodeAffinity().withNewRequired().addNewNodeSelectorTerm().withMatchExpressions(Collections.singletonList(((NodeSelectorRequirementBuilder)((NodeSelectorRequirementBuilder)((NodeSelectorRequirementBuilder)new NodeSelectorRequirementBuilder().withKey("kubernetes.io/hostname")).withOperator("In")).withValues(new String[]{"my-node"})).build()))).endNodeSelectorTerm()).endRequired()).endNodeAffinity()).endSpec()).build();
            ((Resource)client.persistentVolumes().resource((Object)pv)).create();
            logger.info("Successfully created Persistent Volume object");
        }
        catch (KubernetesClientException e) {
            logger.error("Could not create resource: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

