/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.TagReference;
import io.fabric8.openshift.api.model.TagReferenceBuilder;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageStreamExample {
    private static final Logger logger = LoggerFactory.getLogger(ImageStreamExample.class);

    public static void main(String[] args) {
        try (OpenShiftClient client = (OpenShiftClient)new KubernetesClientBuilder().build().adapt(OpenShiftClient.class);){
            String project = Optional.ofNullable(client.getNamespace()).orElse("myproject");
            String imageStreamName = "slave-jenkins";
            ImageStream imageStream = (ImageStream)((Resource)((NonNamespaceOperation)client.imageStreams().inNamespace(project)).resource((Object)((ImageStreamBuilder)((ImageStreamFluent.SpecNested)((ImageStreamFluent.SpecNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName("slave-jenkins")).endMetadata()).withNewSpec().addToTags(Integer.valueOf(0), ((TagReferenceBuilder)((TagReferenceBuilder)new TagReferenceBuilder().withName("base")).withFrom(((ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withKind("DockerImage")).withName("docker.io/openshift/jenkins-slave-maven-centos7:latest")).build())).build())).addToTags(Integer.valueOf(1), ((TagReferenceBuilder)((TagReferenceBuilder)((TagReferenceBuilder)((TagReferenceBuilder)new TagReferenceBuilder().addToAnnotations("role", "jenkins-slave")).addToAnnotations("slave-label", "jenkins-slave")).withName("latest")).withFrom(((ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withKind("ImageStreamTag")).withName("base")).build())).build())).endSpec()).build())).create();
            logger.info("Created ImageStream: {}/{}", (Object)project, (Object)imageStream.getMetadata().getName());
            ImageStream isFromServer = (ImageStream)((Resource)((NonNamespaceOperation)client.imageStreams().inNamespace(project)).withName("slave-jenkins")).get();
            logger.info("Tags in ImageStream are:");
            logger.info(" -  {}", (Object)((TagReference)isFromServer.getSpec().getTags().get(0)).getName());
            logger.info(" -  {}", (Object)((TagReference)isFromServer.getSpec().getTags().get(1)).getName());
            logger.info("Deleting ImageStream");
            ((Resource)((NonNamespaceOperation)client.imageStreams().inNamespace(project)).withName("slave-jenkins")).delete();
        }
    }
}

