/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListBuildConfigs {
    private static final Logger logger = LoggerFactory.getLogger(ListBuildConfigs.class);

    public static void main(String[] args) {
        try (OpenShiftClient client = (OpenShiftClient)new KubernetesClientBuilder().build().adapt(OpenShiftClient.class);){
            if (!client.supportsOpenShiftAPIGroup("build.openshift.io")) {
                logger.warn("This cluster does not support the API Group {}", (Object)"build.openshift.io");
                return;
            }
            BuildConfigList list = (BuildConfigList)client.buildConfigs().list();
            if (list == null) {
                logger.error("No list returned!");
                return;
            }
            List items = list.getItems();
            for (BuildConfig item : items) {
                logger.info("BuildConfig {} has version: {}", (Object)item.getMetadata().getName(), (Object)item.getApiVersion());
            }
        }
        catch (KubernetesClientException e) {
            logger.error("Failed: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

