/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRDLoadExample {
    private static final Logger logger = LoggerFactory.getLogger(CRDLoadExample.class);

    public static void main(String[] args) {
        try (KubernetesClient client = new KubernetesClientBuilder().build();){
            logger.info("Listing all current Custom Resource Definitions :");
            CustomResourceDefinitionList crdList = (CustomResourceDefinitionList)client.apiextensions().v1beta1().customResourceDefinitions().list();
            crdList.getItems().forEach(crd -> logger.info(crd.getMetadata().getName()));
            CustomResourceDefinition aCustomResourceDefinition = (CustomResourceDefinition)((Resource)client.apiextensions().v1beta1().customResourceDefinitions().load(CRDLoadExample.class.getResourceAsStream("/crd.yml"))).get();
            logger.info("Creating CRD...");
            client.apiextensions().v1beta1().customResourceDefinitions().create((Object)aCustomResourceDefinition);
            logger.info("Updated Custom Resource Definitions: ");
            ((CustomResourceDefinitionList)client.apiextensions().v1beta1().customResourceDefinitions().list()).getItems().forEach(crd -> logger.info(crd.getMetadata().getName()));
        }
    }
}

