/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.openshift.client.OpenShiftClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftVersionExample {
    private static final Logger logger = LoggerFactory.getLogger(OpenShiftVersionExample.class);

    public static void main(String[] args) {
        ConfigBuilder configBuilder = new ConfigBuilder();
        if (args.length > 0) {
            configBuilder.withMasterUrl(args[0]);
        }
        try (OpenShiftClient client = (OpenShiftClient)new KubernetesClientBuilder().withConfig(configBuilder.build()).build().adapt(OpenShiftClient.class);){
            VersionInfo openShiftVersionInfo = client.getVersion();
            logger.info("Version details of this OpenShift cluster :-");
            logger.info("Major        : {}", (Object)openShiftVersionInfo.getMajor());
            logger.info("Minor        : {}", (Object)openShiftVersionInfo.getMinor());
            logger.info("GitVersion   : {}", (Object)openShiftVersionInfo.getGitVersion());
            logger.info("BuildDate    : {}", (Object)openShiftVersionInfo.getBuildDate());
            logger.info("GitTreeState : {}", (Object)openShiftVersionInfo.getGitTreeState());
            logger.info("Platform     : {}", (Object)openShiftVersionInfo.getPlatform());
            logger.info("GitVersion   : {}", (Object)openShiftVersionInfo.getGitVersion());
            logger.info("GoVersion    : {}", (Object)openShiftVersionInfo.getGoVersion());
            logger.info("GitCommit    : {}", (Object)openShiftVersionInfo.getGitCommit());
        }
    }
}

