/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.ProjectRequestBuilder;
import io.fabric8.openshift.api.model.ProjectRequestFluent;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentConfigExamples {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentConfigExamples.class);
    private static final String NAMESPACE = "this-is-a-test";
    private static final String IMAGE = "busybox";

    public static void main(String[] args) {
        try (KubernetesClient kubernetesClient = new KubernetesClientBuilder().build();){
            String project;
            OpenShiftClient client = (OpenShiftClient)kubernetesClient.adapt(OpenShiftClient.class);
            if (client.getNamespace() != null) {
                project = client.getNamespace();
                logger.info("Using configured project: {}", (Object)project);
            } else {
                client.projectrequests().create((Object)((ProjectRequestBuilder)((ProjectRequestFluent.MetadataNested)new ProjectRequestBuilder().withNewMetadata().withName(NAMESPACE)).endMetadata()).build());
                project = NAMESPACE;
                logger.info("Created project: {}", (Object)project);
            }
            ServiceAccount fabric8 = ((ServiceAccountBuilder)((ServiceAccountFluent.MetadataNested)new ServiceAccountBuilder().withNewMetadata().withName("fabric8")).endMetadata()).build();
            ((NonNamespaceOperation)client.serviceAccounts().inNamespace(project)).createOrReplace((Object)fabric8);
            DeploymentConfigExamples.log("Created deployment", ((NonNamespaceOperation)client.deploymentConfigs().inNamespace(project)).createOrReplace((Object)((DeploymentConfigBuilder)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigBuilder)((DeploymentConfigFluent.MetadataNested)new DeploymentConfigBuilder().withNewMetadata().withName(IMAGE)).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).addNewTrigger().withType("ConfigChange")).endTrigger()).addToSelector("app", IMAGE)).withNewTemplate().withNewMetadata().addToLabels("app", IMAGE)).endMetadata()).withNewSpec().addNewContainer().withName(IMAGE)).withImage(IMAGE)).addNewPort().withContainerPort(Integer.valueOf(80))).endPort()).endContainer()).endSpec()).endTemplate()).endSpec()).build()));
            ((DeployableScalableResource)((NonNamespaceOperation)client.deploymentConfigs().inNamespace(project)).withName(IMAGE)).scale(2, true);
            DeploymentConfigExamples.log("Created pods:", ((PodList)((NonNamespaceOperation)client.pods().inNamespace(project)).list()).getItems());
            ((DeployableScalableResource)((NonNamespaceOperation)client.deploymentConfigs().inNamespace(project)).withName(IMAGE)).delete();
            DeploymentConfigExamples.log("Pods:", ((PodList)((NonNamespaceOperation)client.pods().inNamespace(project)).list()).getItems());
            DeploymentConfigExamples.log("Replication Controllers:", ((ReplicationControllerList)((NonNamespaceOperation)client.replicationControllers().inNamespace(project)).list()).getItems());
            DeploymentConfigExamples.log("Done.");
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

