/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetrics;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetricsList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopExample {
    private static final Logger logger = LoggerFactory.getLogger(TopExample.class);
    private static final String CPU = "cpu";
    private static final String MEMORY = "memory";

    public static void main(String[] args) {
        try (KubernetesClient client = new KubernetesClientBuilder().build();){
            if (!client.supports(NodeMetrics.class)) {
                logger.warn("Metrics API is not enabled in your cluster");
                return;
            }
            logger.info("==== Node Metrics  ====");
            ((NodeMetricsList)client.top().nodes().metrics()).getItems().forEach(nodeMetrics -> logger.info("{}\tCPU: {}{}\tMemory: {}{}", new Object[]{nodeMetrics.getMetadata().getName(), ((Quantity)nodeMetrics.getUsage().get(CPU)).getAmount(), ((Quantity)nodeMetrics.getUsage().get(CPU)).getFormat(), ((Quantity)nodeMetrics.getUsage().get(MEMORY)).getAmount(), ((Quantity)nodeMetrics.getUsage().get(MEMORY)).getFormat()}));
            String namespace = Optional.ofNullable(client.getNamespace()).orElse("default");
            logger.info("==== Pod Metrics ====");
            client.top().pods().metrics(namespace).getItems().forEach(podMetrics -> podMetrics.getContainers().forEach(containerMetrics -> logger.info("{}\t{}\tCPU: {}{}\tMemory: {}{}", new Object[]{podMetrics.getMetadata().getName(), containerMetrics.getName(), ((Quantity)containerMetrics.getUsage().get(CPU)).getAmount(), ((Quantity)containerMetrics.getUsage().get(CPU)).getFormat(), ((Quantity)containerMetrics.getUsage().get(MEMORY)).getAmount(), ((Quantity)containerMetrics.getUsage().get(MEMORY)).getFormat()})));
            ((PodList)((NonNamespaceOperation)client.pods().inNamespace(namespace)).list()).getItems().stream().findFirst().map(pod -> {
                logger.info("==== Individual Pod Metrics ({}) ====", (Object)pod.getMetadata().getName());
                try {
                    return client.top().pods().metrics(namespace, pod.getMetadata().getName());
                }
                catch (KubernetesClientException ex) {
                    if (ex.getCode() == 404) {
                        logger.info(" - Pod has not reported any metrics yet");
                    } else {
                        logger.warn(" - Error retrieving Pod metrics: {}", (Object)ex.getMessage());
                    }
                    return null;
                }
            }).ifPresent(podMetrics -> podMetrics.getContainers().forEach(containerMetrics -> logger.info("{}\t{}\tCPU: {}{}\tMemory: {}{}", new Object[]{podMetrics.getMetadata().getName(), containerMetrics.getName(), ((Quantity)containerMetrics.getUsage().get(CPU)).getAmount(), ((Quantity)containerMetrics.getUsage().get(CPU)).getFormat(), ((Quantity)containerMetrics.getUsage().get(MEMORY)).getAmount(), ((Quantity)containerMetrics.getUsage().get(MEMORY)).getFormat()})));
        }
        catch (KubernetesClientException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

