/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.policy.v1.PodDisruptionBudget;
import io.fabric8.kubernetes.api.model.policy.v1.PodDisruptionBudgetBuilder;
import io.fabric8.kubernetes.api.model.policy.v1.PodDisruptionBudgetFluent;
import io.fabric8.kubernetes.api.model.policy.v1.PodDisruptionBudgetSpecFluent;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodDisruptionBudgetExample {
    private static final Logger logger = LoggerFactory.getLogger(PodDisruptionBudgetExample.class);

    public static void main(String[] args) {
        ConfigBuilder configBuilder = new ConfigBuilder();
        if (args.length > 0) {
            configBuilder.withMasterUrl(args[0]);
            logger.info("Using master with URL: {}", (Object)args[0]);
        }
        try (KubernetesClient client = new KubernetesClientBuilder().withConfig(configBuilder.build()).build();){
            String namespace = "default";
            PodDisruptionBudget podDisruptionBudget = ((PodDisruptionBudgetBuilder)((PodDisruptionBudgetFluent.SpecNested)((PodDisruptionBudgetSpecFluent.SelectorNested)((PodDisruptionBudgetFluent.SpecNested)((PodDisruptionBudgetBuilder)((PodDisruptionBudgetFluent.MetadataNested)new PodDisruptionBudgetBuilder().withNewMetadata().withName("zk-pkb")).endMetadata()).withNewSpec().withMaxUnavailable(new IntOrString((Object)"1%"))).withNewSelector().withMatchLabels(Collections.singletonMap("app", "zookeeper"))).endSelector()).endSpec()).build();
            logger.info("Current namespace is {}", (Object)"default");
            ((Resource)((NonNamespaceOperation)client.policy().v1().podDisruptionBudget().inNamespace("default")).resource((Object)podDisruptionBudget)).createOrReplace();
        }
        catch (KubernetesClientException e) {
            logger.error("Could not create resource: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

