/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchExample {
    private static final Logger logger = LoggerFactory.getLogger(WatchExample.class);

    public static void main(String[] args) {
        try (KubernetesClient client = new KubernetesClientBuilder().build();
             Watch ignored = WatchExample.newConfigMapWatch(client);){
            String namespace = Optional.ofNullable(client.getNamespace()).orElse("default");
            String name = "watch-config-map-test-" + Utils.generateId();
            ConfigMap cm = (ConfigMap)((Resource)((NonNamespaceOperation)client.configMaps().inNamespace(namespace)).resource((Object)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(name)).endMetadata()).build())).createOrReplace();
            ((Resource)((NonNamespaceOperation)client.configMaps().inNamespace(namespace)).withName(name)).patch((Object)((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(name)).endMetadata()).addToData("key", "value")).build());
            ((Resource)((NonNamespaceOperation)client.configMaps().inNamespace(namespace)).withName(name)).edit(new Visitor[]{new Visitor<ObjectMetaBuilder>(){

                public void visit(ObjectMetaBuilder omb) {
                    omb.addToAnnotations("annotation", "value");
                }
            }});
            ((Resource)client.configMaps().resource((Object)cm)).delete();
        }
        catch (Exception e) {
            logger.error("Global Error: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static Watch newConfigMapWatch(KubernetesClient client) {
        return client.configMaps().watch((Watcher)new Watcher<ConfigMap>(){

            public void eventReceived(Watcher.Action action, ConfigMap resource) {
                logger.info("Watch event received {}: {}", (Object)action.name(), (Object)resource.getMetadata().getName());
            }

            public void onClose(WatcherException e) {
                logger.error("Watch error received: {}", (Object)e.getMessage(), (Object)e);
            }

            public void onClose() {
                logger.info("Watch gracefully closed");
            }
        });
    }
}

