/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSharedIndexInformerExample {
    private static final Logger logger = LoggerFactory.getLogger((String)DynamicSharedIndexInformerExample.class.getSimpleName());

    public static void main(String[] args) {
        ResourceDefinitionContext context = new ResourceDefinitionContext.Builder().withGroup("demo.fabric8.io").withVersion("v1").withPlural("dummies").withKind("Dummy").withNamespaced(true).build();
        try (KubernetesClient client = new KubernetesClientBuilder().build();
             SharedIndexInformer informer = ((AnyNamespaceOperation)client.genericKubernetesResources(context).inAnyNamespace()).runnableInformer(60000L);){
            informer.addEventHandler((ResourceEventHandler)new ResourceEventHandler<GenericKubernetesResource>(){

                public void onAdd(GenericKubernetesResource genericKubernetesResource) {
                    logger.info("ADD {}/{}", (Object)genericKubernetesResource.getMetadata().getNamespace(), (Object)genericKubernetesResource.getMetadata().getName());
                }

                public void onUpdate(GenericKubernetesResource genericKubernetesResource, GenericKubernetesResource t1) {
                    logger.info("UPDATE {}/{}", (Object)genericKubernetesResource.getMetadata().getNamespace(), (Object)genericKubernetesResource.getMetadata().getName());
                }

                public void onDelete(GenericKubernetesResource genericKubernetesResource, boolean b) {
                    logger.info("DELETE {}/{}", (Object)genericKubernetesResource.getMetadata().getNamespace(), (Object)genericKubernetesResource.getMetadata().getName());
                }
            });
            TimeUnit.MINUTES.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            logger.error("interrupted: {}", (Object)interruptedException.getMessage());
        }
    }
}

